/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EndpointAccess;
import software.amazon.awssdk.services.redshift.model.EndpointAccessesCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointAccessResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeEndpointAccessResponse> {
    private static final SdkField<List<EndpointAccess>> ENDPOINT_ACCESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointAccessList").getter(DescribeEndpointAccessResponse.getter(DescribeEndpointAccessResponse::endpointAccessList)).setter(DescribeEndpointAccessResponse.setter(Builder::endpointAccessList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAccessList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEndpointAccessResponse.getter(DescribeEndpointAccessResponse::marker)).setter(DescribeEndpointAccessResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ACCESS_LIST_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointAccessList", ENDPOINT_ACCESS_LIST_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<EndpointAccess> endpointAccessList;
    private final String marker;

    private DescribeEndpointAccessResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAccessList = builder.endpointAccessList;
        this.marker = builder.marker;
    }

    public final boolean hasEndpointAccessList() {
        return this.endpointAccessList != null && !(this.endpointAccessList instanceof SdkAutoConstructList);
    }

    public final List<EndpointAccess> endpointAccessList() {
        return this.endpointAccessList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointAccessList() ? this.endpointAccessList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointAccessResponse)) {
            return false;
        }
        DescribeEndpointAccessResponse other = (DescribeEndpointAccessResponse)((Object)obj);
        return this.hasEndpointAccessList() == other.hasEndpointAccessList() && Objects.equals(this.endpointAccessList(), other.endpointAccessList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointAccessResponse").add("EndpointAccessList", this.hasEndpointAccessList() ? this.endpointAccessList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointAccessList": {
                return Optional.ofNullable(clazz.cast(this.endpointAccessList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointAccessResponse, T> g) {
        return obj -> g.apply((DescribeEndpointAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<EndpointAccess> endpointAccessList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointAccessResponse model) {
            super(model);
            this.endpointAccessList(model.endpointAccessList);
            this.marker(model.marker);
        }

        public final List<EndpointAccess.Builder> getEndpointAccessList() {
            List<EndpointAccess.Builder> result = EndpointAccessesCopier.copyToBuilder(this.endpointAccessList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointAccessList(Collection<EndpointAccess.BuilderImpl> endpointAccessList) {
            this.endpointAccessList = EndpointAccessesCopier.copyFromBuilder(endpointAccessList);
        }

        @Override
        public final Builder endpointAccessList(Collection<EndpointAccess> endpointAccessList) {
            this.endpointAccessList = EndpointAccessesCopier.copy(endpointAccessList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointAccessList(EndpointAccess ... endpointAccessList) {
            this.endpointAccessList(Arrays.asList(endpointAccessList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointAccessList(Consumer<EndpointAccess.Builder> ... endpointAccessList) {
            this.endpointAccessList(Stream.of(endpointAccessList).map(c -> (EndpointAccess)((EndpointAccess.Builder)EndpointAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeEndpointAccessResponse build() {
            return new DescribeEndpointAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointAccessResponse> {
        public Builder endpointAccessList(Collection<EndpointAccess> var1);

        public Builder endpointAccessList(EndpointAccess ... var1);

        public Builder endpointAccessList(Consumer<EndpointAccess.Builder> ... var1);

        public Builder marker(String var1);
    }
}

