/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AssociatedClusterListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledSnapshotTimeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotScheduleResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, CreateSnapshotScheduleResponse> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleDefinitions").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::scheduleDefinitions)).setter(CreateSnapshotScheduleResponse.setter(Builder::scheduleDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(), ListTrait.builder().memberLocationName("ScheduleDefinition").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinition").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleIdentifier").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::scheduleIdentifier)).setter(CreateSnapshotScheduleResponse.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleDescription").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::scheduleDescription)).setter(CreateSnapshotScheduleResponse.setter(Builder::scheduleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::tags)).setter(CreateSnapshotScheduleResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NextInvocations").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::nextInvocations)).setter(CreateSnapshotScheduleResponse.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(), ListTrait.builder().memberLocationName("SnapshotTime").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()}).build()).build()}).build();
    private static final SdkField<Integer> ASSOCIATED_CLUSTER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedClusterCount").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::associatedClusterCount)).setter(CreateSnapshotScheduleResponse.setter(Builder::associatedClusterCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusterCount").build()}).build();
    private static final SdkField<List<ClusterAssociatedToSchedule>> ASSOCIATED_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedClusters").getter(CreateSnapshotScheduleResponse.getter(CreateSnapshotScheduleResponse::associatedClusters)).setter(CreateSnapshotScheduleResponse.setter(Builder::associatedClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusters").build(), ListTrait.builder().memberLocationName("ClusterAssociatedToSchedule").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterAssociatedToSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterAssociatedToSchedule").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD, SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, NEXT_INVOCATIONS_FIELD, ASSOCIATED_CLUSTER_COUNT_FIELD, ASSOCIATED_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ScheduleDefinitions", SCHEDULE_DEFINITIONS_FIELD);
            this.put("ScheduleIdentifier", SCHEDULE_IDENTIFIER_FIELD);
            this.put("ScheduleDescription", SCHEDULE_DESCRIPTION_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("NextInvocations", NEXT_INVOCATIONS_FIELD);
            this.put("AssociatedClusterCount", ASSOCIATED_CLUSTER_COUNT_FIELD);
            this.put("AssociatedClusters", ASSOCIATED_CLUSTERS_FIELD);
        }
    });
    private final List<String> scheduleDefinitions;
    private final String scheduleIdentifier;
    private final String scheduleDescription;
    private final List<Tag> tags;
    private final List<Instant> nextInvocations;
    private final Integer associatedClusterCount;
    private final List<ClusterAssociatedToSchedule> associatedClusters;

    private CreateSnapshotScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.nextInvocations = builder.nextInvocations;
        this.associatedClusterCount = builder.associatedClusterCount;
        this.associatedClusters = builder.associatedClusters;
    }

    public final boolean hasScheduleDefinitions() {
        return this.scheduleDefinitions != null && !(this.scheduleDefinitions instanceof SdkAutoConstructList);
    }

    public final List<String> scheduleDefinitions() {
        return this.scheduleDefinitions;
    }

    public final String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public final String scheduleDescription() {
        return this.scheduleDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasNextInvocations() {
        return this.nextInvocations != null && !(this.nextInvocations instanceof SdkAutoConstructList);
    }

    public final List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public final Integer associatedClusterCount() {
        return this.associatedClusterCount;
    }

    public final boolean hasAssociatedClusters() {
        return this.associatedClusters != null && !(this.associatedClusters instanceof SdkAutoConstructList);
    }

    public final List<ClusterAssociatedToSchedule> associatedClusters() {
        return this.associatedClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextInvocations() ? this.nextInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedClusterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedClusters() ? this.associatedClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotScheduleResponse)) {
            return false;
        }
        CreateSnapshotScheduleResponse other = (CreateSnapshotScheduleResponse)((Object)obj);
        return this.hasScheduleDefinitions() == other.hasScheduleDefinitions() && Objects.equals(this.scheduleDefinitions(), other.scheduleDefinitions()) && Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && Objects.equals(this.scheduleDescription(), other.scheduleDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasNextInvocations() == other.hasNextInvocations() && Objects.equals(this.nextInvocations(), other.nextInvocations()) && Objects.equals(this.associatedClusterCount(), other.associatedClusterCount()) && this.hasAssociatedClusters() == other.hasAssociatedClusters() && Objects.equals(this.associatedClusters(), other.associatedClusters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotScheduleResponse").add("ScheduleDefinitions", this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null).add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("ScheduleDescription", (Object)this.scheduleDescription()).add("Tags", this.hasTags() ? this.tags() : null).add("NextInvocations", this.hasNextInvocations() ? this.nextInvocations() : null).add("AssociatedClusterCount", (Object)this.associatedClusterCount()).add("AssociatedClusters", this.hasAssociatedClusters() ? this.associatedClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleDefinitions": {
                return Optional.ofNullable(clazz.cast(this.scheduleDefinitions()));
            }
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "ScheduleDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduleDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
            case "AssociatedClusterCount": {
                return Optional.ofNullable(clazz.cast(this.associatedClusterCount()));
            }
            case "AssociatedClusters": {
                return Optional.ofNullable(clazz.cast(this.associatedClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotScheduleResponse, T> g) {
        return obj -> g.apply((CreateSnapshotScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String scheduleIdentifier;
        private String scheduleDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();
        private Integer associatedClusterCount;
        private List<ClusterAssociatedToSchedule> associatedClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotScheduleResponse model) {
            super(model);
            this.scheduleDefinitions(model.scheduleDefinitions);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.scheduleDescription(model.scheduleDescription);
            this.tags(model.tags);
            this.nextInvocations(model.nextInvocations);
            this.associatedClusterCount(model.associatedClusterCount);
            this.associatedClusters(model.associatedClusters);
        }

        public final Collection<String> getScheduleDefinitions() {
            if (this.scheduleDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduleDefinitions;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String ... scheduleDefinitions) {
            this.scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final String getScheduleDescription() {
            return this.scheduleDescription;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Instant> getNextInvocations() {
            if (this.nextInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nextInvocations;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final Integer getAssociatedClusterCount() {
            return this.associatedClusterCount;
        }

        public final void setAssociatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
        }

        @Override
        public final Builder associatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
            return this;
        }

        public final List<ClusterAssociatedToSchedule.Builder> getAssociatedClusters() {
            List<ClusterAssociatedToSchedule.Builder> result = AssociatedClusterListCopier.copyToBuilder(this.associatedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedClusters(Collection<ClusterAssociatedToSchedule.BuilderImpl> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copyFromBuilder(associatedClusters);
        }

        @Override
        public final Builder associatedClusters(Collection<ClusterAssociatedToSchedule> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copy(associatedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(ClusterAssociatedToSchedule ... associatedClusters) {
            this.associatedClusters(Arrays.asList(associatedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder> ... associatedClusters) {
            this.associatedClusters(Stream.of(associatedClusters).map(c -> (ClusterAssociatedToSchedule)((ClusterAssociatedToSchedule.Builder)ClusterAssociatedToSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateSnapshotScheduleResponse build() {
            return new CreateSnapshotScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotScheduleResponse> {
        public Builder scheduleDefinitions(Collection<String> var1);

        public Builder scheduleDefinitions(String ... var1);

        public Builder scheduleIdentifier(String var1);

        public Builder scheduleDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);

        public Builder associatedClusterCount(Integer var1);

        public Builder associatedClusters(Collection<ClusterAssociatedToSchedule> var1);

        public Builder associatedClusters(ClusterAssociatedToSchedule ... var1);

        public Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder> ... var1);
    }
}

