/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.InboundIntegration;

public class DescribeInboundIntegrationsPublisher
implements SdkPublisher<DescribeInboundIntegrationsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeInboundIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInboundIntegrationsPublisher(RedshiftAsyncClient client, DescribeInboundIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInboundIntegrationsPublisher(RedshiftAsyncClient client, DescribeInboundIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInboundIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInboundIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InboundIntegration> inboundIntegrations() {
        Function<DescribeInboundIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inboundIntegrations() != null) {
                return response.inboundIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInboundIntegrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInboundIntegrationsResponseFetcher
    implements AsyncPageFetcher<DescribeInboundIntegrationsResponse> {
        private DescribeInboundIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeInboundIntegrationsResponse> nextPage(DescribeInboundIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundIntegrationsPublisher.this.client.describeInboundIntegrations(DescribeInboundIntegrationsPublisher.this.firstRequest);
            }
            return DescribeInboundIntegrationsPublisher.this.client.describeInboundIntegrations((DescribeInboundIntegrationsRequest)((Object)DescribeInboundIntegrationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

