/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.ScheduledAction;

public class DescribeScheduledActionsIterable
implements SdkIterable<DescribeScheduledActionsResponse> {
    private final RedshiftClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScheduledActionsIterable(RedshiftClient client, DescribeScheduledActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public Iterator<DescribeScheduledActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledAction> scheduledActions() {
        Function<DescribeScheduledActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledActions() != null) {
                return response.scheduledActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScheduledActionsResponseFetcher
    implements SyncPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeScheduledActionsResponse nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsIterable.this.client.describeScheduledActions(DescribeScheduledActionsIterable.this.firstRequest);
            }
            return DescribeScheduledActionsIterable.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

