/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ScheduledActionFilter;
import software.amazon.awssdk.services.redshift.model.ScheduledActionFilterListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTypeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeScheduledActionsRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledActionName").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::scheduledActionName)).setter(DescribeScheduledActionsRequest.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build()}).build();
    private static final SdkField<String> TARGET_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetActionType").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::targetActionTypeAsString)).setter(DescribeScheduledActionsRequest.setter(Builder::targetActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetActionType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::startTime)).setter(DescribeScheduledActionsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::endTime)).setter(DescribeScheduledActionsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Active").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::active)).setter(DescribeScheduledActionsRequest.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()}).build();
    private static final SdkField<List<ScheduledActionFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::filters)).setter(DescribeScheduledActionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("ScheduledActionFilter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledActionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionFilter").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::marker)).setter(DescribeScheduledActionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeScheduledActionsRequest.getter(DescribeScheduledActionsRequest::maxRecords)).setter(DescribeScheduledActionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD, TARGET_ACTION_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, ACTIVE_FIELD, FILTERS_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD));
    private final String scheduledActionName;
    private final String targetActionType;
    private final Instant startTime;
    private final Instant endTime;
    private final Boolean active;
    private final List<ScheduledActionFilter> filters;
    private final String marker;
    private final Integer maxRecords;

    private DescribeScheduledActionsRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetActionType = builder.targetActionType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.active = builder.active;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    public final String scheduledActionName() {
        return this.scheduledActionName;
    }

    public final ScheduledActionTypeValues targetActionType() {
        return ScheduledActionTypeValues.fromValue(this.targetActionType);
    }

    public final String targetActionTypeAsString() {
        return this.targetActionType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Boolean active() {
        return this.active;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ScheduledActionFilter> filters() {
        return this.filters;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest)((Object)obj);
        return Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.targetActionTypeAsString(), other.targetActionTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.active(), other.active()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledActionsRequest").add("ScheduledActionName", (Object)this.scheduledActionName()).add("TargetActionType", (Object)this.targetActionTypeAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Active", (Object)this.active()).add("Filters", this.hasFilters() ? this.filters() : null).add("Marker", (Object)this.marker()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "TargetActionType": {
                return Optional.ofNullable(clazz.cast(this.targetActionTypeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsRequest, T> g) {
        return obj -> g.apply((DescribeScheduledActionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String scheduledActionName;
        private String targetActionType;
        private Instant startTime;
        private Instant endTime;
        private Boolean active;
        private List<ScheduledActionFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsRequest model) {
            super(model);
            this.scheduledActionName(model.scheduledActionName);
            this.targetActionType(model.targetActionType);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.active(model.active);
            this.filters(model.filters);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final String getTargetActionType() {
            return this.targetActionType;
        }

        public final void setTargetActionType(String targetActionType) {
            this.targetActionType = targetActionType;
        }

        @Override
        public final Builder targetActionType(String targetActionType) {
            this.targetActionType = targetActionType;
            return this;
        }

        @Override
        public final Builder targetActionType(ScheduledActionTypeValues targetActionType) {
            this.targetActionType(targetActionType == null ? null : targetActionType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final List<ScheduledActionFilter.Builder> getFilters() {
            List<ScheduledActionFilter.Builder> result = ScheduledActionFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ScheduledActionFilter.BuilderImpl> filters) {
            this.filters = ScheduledActionFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ScheduledActionFilter> filters) {
            this.filters = ScheduledActionFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ScheduledActionFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ScheduledActionFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ScheduledActionFilter)((ScheduledActionFilter.Builder)ScheduledActionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledActionsRequest build() {
            return new DescribeScheduledActionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsRequest> {
        public Builder scheduledActionName(String var1);

        public Builder targetActionType(String var1);

        public Builder targetActionType(ScheduledActionTypeValues var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder active(Boolean var1);

        public Builder filters(Collection<ScheduledActionFilter> var1);

        public Builder filters(ScheduledActionFilter ... var1);

        public Builder filters(Consumer<ScheduledActionFilter.Builder> ... var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

