/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;

public class DescribeHsmConfigurationsIterable
implements SdkIterable<DescribeHsmConfigurationsResponse> {
    private final RedshiftClient client;
    private final DescribeHsmConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHsmConfigurationsIterable(RedshiftClient client, DescribeHsmConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeHsmConfigurationsResponseFetcher();
    }

    public Iterator<DescribeHsmConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HsmConfiguration> hsmConfigurations() {
        Function<DescribeHsmConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hsmConfigurations() != null) {
                return response.hsmConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeHsmConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeHsmConfigurationsResponse> {
        private DescribeHsmConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeHsmConfigurationsResponse nextPage(DescribeHsmConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmConfigurationsIterable.this.client.describeHsmConfigurations(DescribeHsmConfigurationsIterable.this.firstRequest);
            }
            return DescribeHsmConfigurationsIterable.this.client.describeHsmConfigurations((DescribeHsmConfigurationsRequest)((Object)DescribeHsmConfigurationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

