/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuerListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationListCopier;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyRedshiftIdcApplicationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyRedshiftIdcApplicationRequest> {
    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftIdcApplicationArn").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::redshiftIdcApplicationArn)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::redshiftIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationArn").build()}).build();
    private static final SdkField<String> IDENTITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityNamespace").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::identityNamespace)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::identityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityNamespace").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::iamRoleArn)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> IDC_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcDisplayName").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::idcDisplayName)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::idcDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcDisplayName").build()}).build();
    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTokenIssuerList").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::authorizedTokenIssuerList)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::authorizedTokenIssuerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedTokenIssuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceIntegrationsUnion>> SERVICE_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceIntegrations").getter(ModifyRedshiftIdcApplicationRequest.getter(ModifyRedshiftIdcApplicationRequest::serviceIntegrations)).setter(ModifyRedshiftIdcApplicationRequest.setter(Builder::serviceIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceIntegrationsUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_IDC_APPLICATION_ARN_FIELD, IDENTITY_NAMESPACE_FIELD, IAM_ROLE_ARN_FIELD, IDC_DISPLAY_NAME_FIELD, AUTHORIZED_TOKEN_ISSUER_LIST_FIELD, SERVICE_INTEGRATIONS_FIELD));
    private final String redshiftIdcApplicationArn;
    private final String identityNamespace;
    private final String iamRoleArn;
    private final String idcDisplayName;
    private final List<AuthorizedTokenIssuer> authorizedTokenIssuerList;
    private final List<ServiceIntegrationsUnion> serviceIntegrations;

    private ModifyRedshiftIdcApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.redshiftIdcApplicationArn = builder.redshiftIdcApplicationArn;
        this.identityNamespace = builder.identityNamespace;
        this.iamRoleArn = builder.iamRoleArn;
        this.idcDisplayName = builder.idcDisplayName;
        this.authorizedTokenIssuerList = builder.authorizedTokenIssuerList;
        this.serviceIntegrations = builder.serviceIntegrations;
    }

    public final String redshiftIdcApplicationArn() {
        return this.redshiftIdcApplicationArn;
    }

    public final String identityNamespace() {
        return this.identityNamespace;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String idcDisplayName() {
        return this.idcDisplayName;
    }

    public final boolean hasAuthorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList != null && !(this.authorizedTokenIssuerList instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedTokenIssuer> authorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList;
    }

    public final boolean hasServiceIntegrations() {
        return this.serviceIntegrations != null && !(this.serviceIntegrations instanceof SdkAutoConstructList);
    }

    public final List<ServiceIntegrationsUnion> serviceIntegrations() {
        return this.serviceIntegrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceIntegrations() ? this.serviceIntegrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRedshiftIdcApplicationRequest)) {
            return false;
        }
        ModifyRedshiftIdcApplicationRequest other = (ModifyRedshiftIdcApplicationRequest)((Object)obj);
        return Objects.equals(this.redshiftIdcApplicationArn(), other.redshiftIdcApplicationArn()) && Objects.equals(this.identityNamespace(), other.identityNamespace()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.idcDisplayName(), other.idcDisplayName()) && this.hasAuthorizedTokenIssuerList() == other.hasAuthorizedTokenIssuerList() && Objects.equals(this.authorizedTokenIssuerList(), other.authorizedTokenIssuerList()) && this.hasServiceIntegrations() == other.hasServiceIntegrations() && Objects.equals(this.serviceIntegrations(), other.serviceIntegrations());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyRedshiftIdcApplicationRequest").add("RedshiftIdcApplicationArn", (Object)this.redshiftIdcApplicationArn()).add("IdentityNamespace", (Object)this.identityNamespace()).add("IamRoleArn", (Object)this.iamRoleArn()).add("IdcDisplayName", (Object)this.idcDisplayName()).add("AuthorizedTokenIssuerList", this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null).add("ServiceIntegrations", this.hasServiceIntegrations() ? this.serviceIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedshiftIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.redshiftIdcApplicationArn()));
            }
            case "IdentityNamespace": {
                return Optional.ofNullable(clazz.cast(this.identityNamespace()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "IdcDisplayName": {
                return Optional.ofNullable(clazz.cast(this.idcDisplayName()));
            }
            case "AuthorizedTokenIssuerList": {
                return Optional.ofNullable(clazz.cast(this.authorizedTokenIssuerList()));
            }
            case "ServiceIntegrations": {
                return Optional.ofNullable(clazz.cast(this.serviceIntegrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyRedshiftIdcApplicationRequest, T> g) {
        return obj -> g.apply((ModifyRedshiftIdcApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String redshiftIdcApplicationArn;
        private String identityNamespace;
        private String iamRoleArn;
        private String idcDisplayName;
        private List<AuthorizedTokenIssuer> authorizedTokenIssuerList = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceIntegrationsUnion> serviceIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRedshiftIdcApplicationRequest model) {
            super(model);
            this.redshiftIdcApplicationArn(model.redshiftIdcApplicationArn);
            this.identityNamespace(model.identityNamespace);
            this.iamRoleArn(model.iamRoleArn);
            this.idcDisplayName(model.idcDisplayName);
            this.authorizedTokenIssuerList(model.authorizedTokenIssuerList);
            this.serviceIntegrations(model.serviceIntegrations);
        }

        public final String getRedshiftIdcApplicationArn() {
            return this.redshiftIdcApplicationArn;
        }

        public final void setRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
        }

        @Override
        public final Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
            return this;
        }

        public final String getIdentityNamespace() {
            return this.identityNamespace;
        }

        public final void setIdentityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
        }

        @Override
        public final Builder identityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdcDisplayName() {
            return this.idcDisplayName;
        }

        public final void setIdcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
        }

        @Override
        public final Builder idcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
            return this;
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuerList() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuerListCopier.copyToBuilder(this.authorizedTokenIssuerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuerList(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copyFromBuilder(authorizedTokenIssuerList);
        }

        @Override
        public final Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copy(authorizedTokenIssuerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Arrays.asList(authorizedTokenIssuerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Stream.of(authorizedTokenIssuerList).map(c -> (AuthorizedTokenIssuer)((AuthorizedTokenIssuer.Builder)AuthorizedTokenIssuer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceIntegrationsUnion.Builder> getServiceIntegrations() {
            List<ServiceIntegrationsUnion.Builder> result = ServiceIntegrationListCopier.copyToBuilder(this.serviceIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIntegrations(Collection<ServiceIntegrationsUnion.BuilderImpl> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copyFromBuilder(serviceIntegrations);
        }

        @Override
        public final Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copy(serviceIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(ServiceIntegrationsUnion ... serviceIntegrations) {
            this.serviceIntegrations(Arrays.asList(serviceIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... serviceIntegrations) {
            this.serviceIntegrations(Stream.of(serviceIntegrations).map(c -> (ServiceIntegrationsUnion)((ServiceIntegrationsUnion.Builder)ServiceIntegrationsUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyRedshiftIdcApplicationRequest build() {
            return new ModifyRedshiftIdcApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyRedshiftIdcApplicationRequest> {
        public Builder redshiftIdcApplicationArn(String var1);

        public Builder identityNamespace(String var1);

        public Builder iamRoleArn(String var1);

        public Builder idcDisplayName(String var1);

        public Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> var1);

        public Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... var1);

        public Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... var1);

        public Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> var1);

        public Builder serviceIntegrations(ServiceIntegrationsUnion ... var1);

        public Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

