/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains properties for the Redshift IDC application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftIdcApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftIdcApplication.Builder, RedshiftIdcApplication> {
    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdcInstanceArn").getter(getter(RedshiftIdcApplication::idcInstanceArn))
            .setter(setter(Builder::idcInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcInstanceArn").build()).build();

    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RedshiftIdcApplicationName")
            .getter(getter(RedshiftIdcApplication::redshiftIdcApplicationName))
            .setter(setter(Builder::redshiftIdcApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationName").build())
            .build();

    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftIdcApplicationArn").getter(getter(RedshiftIdcApplication::redshiftIdcApplicationArn))
            .setter(setter(Builder::redshiftIdcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationArn").build())
            .build();

    private static final SdkField<String> IDENTITY_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityNamespace").getter(getter(RedshiftIdcApplication::identityNamespace))
            .setter(setter(Builder::identityNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityNamespace").build()).build();

    private static final SdkField<String> IDC_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdcDisplayName").getter(getter(RedshiftIdcApplication::idcDisplayName))
            .setter(setter(Builder::idcDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcDisplayName").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(RedshiftIdcApplication::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> IDC_MANAGED_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdcManagedApplicationArn").getter(getter(RedshiftIdcApplication::idcManagedApplicationArn))
            .setter(setter(Builder::idcManagedApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcManagedApplicationArn").build())
            .build();

    private static final SdkField<String> IDC_ONBOARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdcOnboardStatus").getter(getter(RedshiftIdcApplication::idcOnboardStatus))
            .setter(setter(Builder::idcOnboardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcOnboardStatus").build()).build();

    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUER_LIST_FIELD = SdkField
            .<List<AuthorizedTokenIssuer>> builder(MarshallingType.LIST)
            .memberName("AuthorizedTokenIssuerList")
            .getter(getter(RedshiftIdcApplication::authorizedTokenIssuerList))
            .setter(setter(Builder::authorizedTokenIssuerList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuerList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizedTokenIssuer> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizedTokenIssuer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceIntegrationsUnion>> SERVICE_INTEGRATIONS_FIELD = SdkField
            .<List<ServiceIntegrationsUnion>> builder(MarshallingType.LIST)
            .memberName("ServiceIntegrations")
            .getter(getter(RedshiftIdcApplication::serviceIntegrations))
            .setter(setter(Builder::serviceIntegrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceIntegrationsUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceIntegrationsUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDC_INSTANCE_ARN_FIELD,
            REDSHIFT_IDC_APPLICATION_NAME_FIELD, REDSHIFT_IDC_APPLICATION_ARN_FIELD, IDENTITY_NAMESPACE_FIELD,
            IDC_DISPLAY_NAME_FIELD, IAM_ROLE_ARN_FIELD, IDC_MANAGED_APPLICATION_ARN_FIELD, IDC_ONBOARD_STATUS_FIELD,
            AUTHORIZED_TOKEN_ISSUER_LIST_FIELD, SERVICE_INTEGRATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String idcInstanceArn;

    private final String redshiftIdcApplicationName;

    private final String redshiftIdcApplicationArn;

    private final String identityNamespace;

    private final String idcDisplayName;

    private final String iamRoleArn;

    private final String idcManagedApplicationArn;

    private final String idcOnboardStatus;

    private final List<AuthorizedTokenIssuer> authorizedTokenIssuerList;

    private final List<ServiceIntegrationsUnion> serviceIntegrations;

    private RedshiftIdcApplication(BuilderImpl builder) {
        this.idcInstanceArn = builder.idcInstanceArn;
        this.redshiftIdcApplicationName = builder.redshiftIdcApplicationName;
        this.redshiftIdcApplicationArn = builder.redshiftIdcApplicationArn;
        this.identityNamespace = builder.identityNamespace;
        this.idcDisplayName = builder.idcDisplayName;
        this.iamRoleArn = builder.iamRoleArn;
        this.idcManagedApplicationArn = builder.idcManagedApplicationArn;
        this.idcOnboardStatus = builder.idcOnboardStatus;
        this.authorizedTokenIssuerList = builder.authorizedTokenIssuerList;
        this.serviceIntegrations = builder.serviceIntegrations;
    }

    /**
     * <p>
     * The ARN for the IAM Identity Center instance that Redshift integrates with.
     * </p>
     * 
     * @return The ARN for the IAM Identity Center instance that Redshift integrates with.
     */
    public final String idcInstanceArn() {
        return idcInstanceArn;
    }

    /**
     * <p>
     * The name of the Redshift application in IAM Identity Center.
     * </p>
     * 
     * @return The name of the Redshift application in IAM Identity Center.
     */
    public final String redshiftIdcApplicationName() {
        return redshiftIdcApplicationName;
    }

    /**
     * <p>
     * The ARN for the Redshift application that integrates with IAM Identity Center.
     * </p>
     * 
     * @return The ARN for the Redshift application that integrates with IAM Identity Center.
     */
    public final String redshiftIdcApplicationArn() {
        return redshiftIdcApplicationArn;
    }

    /**
     * <p>
     * The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which managed
     * application verifies the connection token.
     * </p>
     * 
     * @return The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which
     *         managed application verifies the connection token.
     */
    public final String identityNamespace() {
        return identityNamespace;
    }

    /**
     * <p>
     * The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
     * </p>
     * 
     * @return The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
     */
    public final String idcDisplayName() {
        return idcDisplayName;
    }

    /**
     * <p>
     * The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be assumed
     * and invoke the IDC Identity Center API.
     * </p>
     * 
     * @return The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be
     *         assumed and invoke the IDC Identity Center API.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ARN for the Amazon Redshift IAM Identity Center application.
     * </p>
     * 
     * @return The ARN for the Amazon Redshift IAM Identity Center application.
     */
    public final String idcManagedApplicationArn() {
        return idcManagedApplicationArn;
    }

    /**
     * <p>
     * The onboarding status for the Amazon Redshift IAM Identity Center application.
     * </p>
     * 
     * @return The onboarding status for the Amazon Redshift IAM Identity Center application.
     */
    public final String idcOnboardStatus() {
        return idcOnboardStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedTokenIssuerList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthorizedTokenIssuerList() {
        return authorizedTokenIssuerList != null && !(authorizedTokenIssuerList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedTokenIssuerList} method.
     * </p>
     * 
     * @return The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
     */
    public final List<AuthorizedTokenIssuer> authorizedTokenIssuerList() {
        return authorizedTokenIssuerList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceIntegrations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceIntegrations() {
        return serviceIntegrations != null && !(serviceIntegrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of service integrations for the Redshift IAM Identity Center application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceIntegrations} method.
     * </p>
     * 
     * @return A list of service integrations for the Redshift IAM Identity Center application.
     */
    public final List<ServiceIntegrationsUnion> serviceIntegrations() {
        return serviceIntegrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftIdcApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(idcDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(idcManagedApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(idcOnboardStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedTokenIssuerList() ? authorizedTokenIssuerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceIntegrations() ? serviceIntegrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftIdcApplication)) {
            return false;
        }
        RedshiftIdcApplication other = (RedshiftIdcApplication) obj;
        return Objects.equals(idcInstanceArn(), other.idcInstanceArn())
                && Objects.equals(redshiftIdcApplicationName(), other.redshiftIdcApplicationName())
                && Objects.equals(redshiftIdcApplicationArn(), other.redshiftIdcApplicationArn())
                && Objects.equals(identityNamespace(), other.identityNamespace())
                && Objects.equals(idcDisplayName(), other.idcDisplayName()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(idcManagedApplicationArn(), other.idcManagedApplicationArn())
                && Objects.equals(idcOnboardStatus(), other.idcOnboardStatus())
                && hasAuthorizedTokenIssuerList() == other.hasAuthorizedTokenIssuerList()
                && Objects.equals(authorizedTokenIssuerList(), other.authorizedTokenIssuerList())
                && hasServiceIntegrations() == other.hasServiceIntegrations()
                && Objects.equals(serviceIntegrations(), other.serviceIntegrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftIdcApplication").add("IdcInstanceArn", idcInstanceArn())
                .add("RedshiftIdcApplicationName", redshiftIdcApplicationName())
                .add("RedshiftIdcApplicationArn", redshiftIdcApplicationArn()).add("IdentityNamespace", identityNamespace())
                .add("IdcDisplayName", idcDisplayName()).add("IamRoleArn", iamRoleArn())
                .add("IdcManagedApplicationArn", idcManagedApplicationArn()).add("IdcOnboardStatus", idcOnboardStatus())
                .add("AuthorizedTokenIssuerList", hasAuthorizedTokenIssuerList() ? authorizedTokenIssuerList() : null)
                .add("ServiceIntegrations", hasServiceIntegrations() ? serviceIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdcInstanceArn":
            return Optional.ofNullable(clazz.cast(idcInstanceArn()));
        case "RedshiftIdcApplicationName":
            return Optional.ofNullable(clazz.cast(redshiftIdcApplicationName()));
        case "RedshiftIdcApplicationArn":
            return Optional.ofNullable(clazz.cast(redshiftIdcApplicationArn()));
        case "IdentityNamespace":
            return Optional.ofNullable(clazz.cast(identityNamespace()));
        case "IdcDisplayName":
            return Optional.ofNullable(clazz.cast(idcDisplayName()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "IdcManagedApplicationArn":
            return Optional.ofNullable(clazz.cast(idcManagedApplicationArn()));
        case "IdcOnboardStatus":
            return Optional.ofNullable(clazz.cast(idcOnboardStatus()));
        case "AuthorizedTokenIssuerList":
            return Optional.ofNullable(clazz.cast(authorizedTokenIssuerList()));
        case "ServiceIntegrations":
            return Optional.ofNullable(clazz.cast(serviceIntegrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftIdcApplication, T> g) {
        return obj -> g.apply((RedshiftIdcApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftIdcApplication> {
        /**
         * <p>
         * The ARN for the IAM Identity Center instance that Redshift integrates with.
         * </p>
         * 
         * @param idcInstanceArn
         *        The ARN for the IAM Identity Center instance that Redshift integrates with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcInstanceArn(String idcInstanceArn);

        /**
         * <p>
         * The name of the Redshift application in IAM Identity Center.
         * </p>
         * 
         * @param redshiftIdcApplicationName
         *        The name of the Redshift application in IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftIdcApplicationName(String redshiftIdcApplicationName);

        /**
         * <p>
         * The ARN for the Redshift application that integrates with IAM Identity Center.
         * </p>
         * 
         * @param redshiftIdcApplicationArn
         *        The ARN for the Redshift application that integrates with IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn);

        /**
         * <p>
         * The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which managed
         * application verifies the connection token.
         * </p>
         * 
         * @param identityNamespace
         *        The identity namespace for the Amazon Redshift IAM Identity Center application. It determines which
         *        managed application verifies the connection token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityNamespace(String identityNamespace);

        /**
         * <p>
         * The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
         * </p>
         * 
         * @param idcDisplayName
         *        The display name for the Amazon Redshift IAM Identity Center application. It appears on the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcDisplayName(String idcDisplayName);

        /**
         * <p>
         * The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be
         * assumed and invoke the IDC Identity Center API.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN for the Amazon Redshift IAM Identity Center application. It has the required permissions to be
         *        assumed and invoke the IDC Identity Center API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ARN for the Amazon Redshift IAM Identity Center application.
         * </p>
         * 
         * @param idcManagedApplicationArn
         *        The ARN for the Amazon Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcManagedApplicationArn(String idcManagedApplicationArn);

        /**
         * <p>
         * The onboarding status for the Amazon Redshift IAM Identity Center application.
         * </p>
         * 
         * @param idcOnboardStatus
         *        The onboarding status for the Amazon Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcOnboardStatus(String idcOnboardStatus);

        /**
         * <p>
         * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         * </p>
         * 
         * @param authorizedTokenIssuerList
         *        The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> authorizedTokenIssuerList);

        /**
         * <p>
         * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         * </p>
         * 
         * @param authorizedTokenIssuerList
         *        The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTokenIssuerList(AuthorizedTokenIssuer... authorizedTokenIssuerList);

        /**
         * <p>
         * The authorized token issuer list for the Amazon Redshift IAM Identity Center application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer.Builder#build()} is called
         * immediately and its result is passed to {@link #authorizedTokenIssuerList(List<AuthorizedTokenIssuer>)}.
         * 
         * @param authorizedTokenIssuerList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizedTokenIssuerList(java.util.Collection<AuthorizedTokenIssuer>)
         */
        Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder>... authorizedTokenIssuerList);

        /**
         * <p>
         * A list of service integrations for the Redshift IAM Identity Center application.
         * </p>
         * 
         * @param serviceIntegrations
         *        A list of service integrations for the Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> serviceIntegrations);

        /**
         * <p>
         * A list of service integrations for the Redshift IAM Identity Center application.
         * </p>
         * 
         * @param serviceIntegrations
         *        A list of service integrations for the Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIntegrations(ServiceIntegrationsUnion... serviceIntegrations);

        /**
         * <p>
         * A list of service integrations for the Redshift IAM Identity Center application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceIntegrations(List<ServiceIntegrationsUnion>)}.
         * 
         * @param serviceIntegrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIntegrations(java.util.Collection<ServiceIntegrationsUnion>)
         */
        Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder>... serviceIntegrations);
    }

    static final class BuilderImpl implements Builder {
        private String idcInstanceArn;

        private String redshiftIdcApplicationName;

        private String redshiftIdcApplicationArn;

        private String identityNamespace;

        private String idcDisplayName;

        private String iamRoleArn;

        private String idcManagedApplicationArn;

        private String idcOnboardStatus;

        private List<AuthorizedTokenIssuer> authorizedTokenIssuerList = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceIntegrationsUnion> serviceIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftIdcApplication model) {
            idcInstanceArn(model.idcInstanceArn);
            redshiftIdcApplicationName(model.redshiftIdcApplicationName);
            redshiftIdcApplicationArn(model.redshiftIdcApplicationArn);
            identityNamespace(model.identityNamespace);
            idcDisplayName(model.idcDisplayName);
            iamRoleArn(model.iamRoleArn);
            idcManagedApplicationArn(model.idcManagedApplicationArn);
            idcOnboardStatus(model.idcOnboardStatus);
            authorizedTokenIssuerList(model.authorizedTokenIssuerList);
            serviceIntegrations(model.serviceIntegrations);
        }

        public final String getIdcInstanceArn() {
            return idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final String getRedshiftIdcApplicationName() {
            return redshiftIdcApplicationName;
        }

        public final void setRedshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
        }

        @Override
        public final Builder redshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
            return this;
        }

        public final String getRedshiftIdcApplicationArn() {
            return redshiftIdcApplicationArn;
        }

        public final void setRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
        }

        @Override
        public final Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
            return this;
        }

        public final String getIdentityNamespace() {
            return identityNamespace;
        }

        public final void setIdentityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
        }

        @Override
        public final Builder identityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
            return this;
        }

        public final String getIdcDisplayName() {
            return idcDisplayName;
        }

        public final void setIdcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
        }

        @Override
        public final Builder idcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdcManagedApplicationArn() {
            return idcManagedApplicationArn;
        }

        public final void setIdcManagedApplicationArn(String idcManagedApplicationArn) {
            this.idcManagedApplicationArn = idcManagedApplicationArn;
        }

        @Override
        public final Builder idcManagedApplicationArn(String idcManagedApplicationArn) {
            this.idcManagedApplicationArn = idcManagedApplicationArn;
            return this;
        }

        public final String getIdcOnboardStatus() {
            return idcOnboardStatus;
        }

        public final void setIdcOnboardStatus(String idcOnboardStatus) {
            this.idcOnboardStatus = idcOnboardStatus;
        }

        @Override
        public final Builder idcOnboardStatus(String idcOnboardStatus) {
            this.idcOnboardStatus = idcOnboardStatus;
            return this;
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuerList() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuerListCopier
                    .copyToBuilder(this.authorizedTokenIssuerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuerList(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copyFromBuilder(authorizedTokenIssuerList);
        }

        @Override
        public final Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copy(authorizedTokenIssuerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(AuthorizedTokenIssuer... authorizedTokenIssuerList) {
            authorizedTokenIssuerList(Arrays.asList(authorizedTokenIssuerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder>... authorizedTokenIssuerList) {
            authorizedTokenIssuerList(Stream.of(authorizedTokenIssuerList)
                    .map(c -> AuthorizedTokenIssuer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceIntegrationsUnion.Builder> getServiceIntegrations() {
            List<ServiceIntegrationsUnion.Builder> result = ServiceIntegrationListCopier.copyToBuilder(this.serviceIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIntegrations(Collection<ServiceIntegrationsUnion.BuilderImpl> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copyFromBuilder(serviceIntegrations);
        }

        @Override
        public final Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copy(serviceIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(ServiceIntegrationsUnion... serviceIntegrations) {
            serviceIntegrations(Arrays.asList(serviceIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder>... serviceIntegrations) {
            serviceIntegrations(Stream.of(serviceIntegrations)
                    .map(c -> ServiceIntegrationsUnion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RedshiftIdcApplication build() {
            return new RedshiftIdcApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
