/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateDataShareConsumerRequest extends RedshiftRequest implements
        ToCopyableBuilder<DisassociateDataShareConsumerRequest.Builder, DisassociateDataShareConsumerRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataShareArn").getter(getter(DisassociateDataShareConsumerRequest::dataShareArn))
            .setter(setter(Builder::dataShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_ENTIRE_ACCOUNT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisassociateEntireAccount")
            .getter(getter(DisassociateDataShareConsumerRequest::disassociateEntireAccount))
            .setter(setter(Builder::disassociateEntireAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateEntireAccount").build())
            .build();

    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerArn").getter(getter(DisassociateDataShareConsumerRequest::consumerArn))
            .setter(setter(Builder::consumerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerArn").build()).build();

    private static final SdkField<String> CONSUMER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerRegion").getter(getter(DisassociateDataShareConsumerRequest::consumerRegion))
            .setter(setter(Builder::consumerRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD,
            DISASSOCIATE_ENTIRE_ACCOUNT_FIELD, CONSUMER_ARN_FIELD, CONSUMER_REGION_FIELD));

    private final String dataShareArn;

    private final Boolean disassociateEntireAccount;

    private final String consumerArn;

    private final String consumerRegion;

    private DisassociateDataShareConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.disassociateEntireAccount = builder.disassociateEntireAccount;
        this.consumerArn = builder.consumerArn;
        this.consumerRegion = builder.consumerRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the datashare to remove association for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the datashare to remove association for.
     */
    public final String dataShareArn() {
        return dataShareArn;
    }

    /**
     * <p>
     * A value that specifies whether association for the datashare is removed from the entire account.
     * </p>
     * 
     * @return A value that specifies whether association for the datashare is removed from the entire account.
     */
    public final Boolean disassociateEntireAccount() {
        return disassociateEntireAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.
     */
    public final String consumerArn() {
        return consumerArn;
    }

    /**
     * <p>
     * From a datashare consumer account, removes association of a datashare from all the existing and future namespaces
     * in the specified Amazon Web Services Region.
     * </p>
     * 
     * @return From a datashare consumer account, removes association of a datashare from all the existing and future
     *         namespaces in the specified Amazon Web Services Region.
     */
    public final String consumerRegion() {
        return consumerRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateEntireAccount());
        hashCode = 31 * hashCode + Objects.hashCode(consumerArn());
        hashCode = 31 * hashCode + Objects.hashCode(consumerRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateDataShareConsumerRequest)) {
            return false;
        }
        DisassociateDataShareConsumerRequest other = (DisassociateDataShareConsumerRequest) obj;
        return Objects.equals(dataShareArn(), other.dataShareArn())
                && Objects.equals(disassociateEntireAccount(), other.disassociateEntireAccount())
                && Objects.equals(consumerArn(), other.consumerArn()) && Objects.equals(consumerRegion(), other.consumerRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateDataShareConsumerRequest").add("DataShareArn", dataShareArn())
                .add("DisassociateEntireAccount", disassociateEntireAccount()).add("ConsumerArn", consumerArn())
                .add("ConsumerRegion", consumerRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShareArn":
            return Optional.ofNullable(clazz.cast(dataShareArn()));
        case "DisassociateEntireAccount":
            return Optional.ofNullable(clazz.cast(disassociateEntireAccount()));
        case "ConsumerArn":
            return Optional.ofNullable(clazz.cast(consumerArn()));
        case "ConsumerRegion":
            return Optional.ofNullable(clazz.cast(consumerRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateDataShareConsumerRequest, T> g) {
        return obj -> g.apply((DisassociateDataShareConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateDataShareConsumerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the datashare to remove association for.
         * </p>
         * 
         * @param dataShareArn
         *        The Amazon Resource Name (ARN) of the datashare to remove association for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareArn(String dataShareArn);

        /**
         * <p>
         * A value that specifies whether association for the datashare is removed from the entire account.
         * </p>
         * 
         * @param disassociateEntireAccount
         *        A value that specifies whether association for the datashare is removed from the entire account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateEntireAccount(Boolean disassociateEntireAccount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.
         * </p>
         * 
         * @param consumerArn
         *        The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerArn(String consumerArn);

        /**
         * <p>
         * From a datashare consumer account, removes association of a datashare from all the existing and future
         * namespaces in the specified Amazon Web Services Region.
         * </p>
         * 
         * @param consumerRegion
         *        From a datashare consumer account, removes association of a datashare from all the existing and future
         *        namespaces in the specified Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerRegion(String consumerRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String dataShareArn;

        private Boolean disassociateEntireAccount;

        private String consumerArn;

        private String consumerRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateDataShareConsumerRequest model) {
            super(model);
            dataShareArn(model.dataShareArn);
            disassociateEntireAccount(model.disassociateEntireAccount);
            consumerArn(model.consumerArn);
            consumerRegion(model.consumerRegion);
        }

        public final String getDataShareArn() {
            return dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final Boolean getDisassociateEntireAccount() {
            return disassociateEntireAccount;
        }

        public final void setDisassociateEntireAccount(Boolean disassociateEntireAccount) {
            this.disassociateEntireAccount = disassociateEntireAccount;
        }

        @Override
        public final Builder disassociateEntireAccount(Boolean disassociateEntireAccount) {
            this.disassociateEntireAccount = disassociateEntireAccount;
            return this;
        }

        public final String getConsumerArn() {
            return consumerArn;
        }

        public final void setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
        }

        @Override
        public final Builder consumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        public final String getConsumerRegion() {
            return consumerRegion;
        }

        public final void setConsumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
        }

        @Override
        public final Builder consumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateDataShareConsumerRequest build() {
            return new DisassociateDataShareConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
