/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeConfigurationOptionsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeNodeConfigurationOptionsRequest.Builder, DescribeNodeConfigurationOptionsRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(DescribeNodeConfigurationOptionsRequest::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(DescribeNodeConfigurationOptionsRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(DescribeNodeConfigurationOptionsRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotArn").getter(getter(DescribeNodeConfigurationOptionsRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(DescribeNodeConfigurationOptionsRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<List<NodeConfigurationOptionsFilter>> FILTERS_FIELD = SdkField
            .<List<NodeConfigurationOptionsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeNodeConfigurationOptionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeConfigurationOptionsFilter")
                            .memberFieldInfo(
                                    SdkField.<NodeConfigurationOptionsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeConfigurationOptionsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeConfigurationOptionsFilter").build()).build()).build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeNodeConfigurationOptionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeNodeConfigurationOptionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_ARN_FIELD, OWNER_ACCOUNT_FIELD, FILTERS_FIELD,
            MARKER_FIELD, MAX_RECORDS_FIELD));

    private final String actionType;

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String snapshotArn;

    private final String ownerAccount;

    private final List<NodeConfigurationOptionsFilter> filters;

    private final String marker;

    private final Integer maxRecords;

    private DescribeNodeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.ownerAccount = builder.ownerAccount;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
     * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations
     * based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic
     * resize based on an existing cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
     *         configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
     *         configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get
     *         configuration combinations for elastic resize based on an existing cluster.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
     * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations
     * based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic
     * resize based on an existing cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
     *         configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
     *         configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get
     *         configuration combinations for elastic resize based on an existing cluster.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The identifier of the cluster to evaluate for possible node configurations.
     * </p>
     * 
     * @return The identifier of the cluster to evaluate for possible node configurations.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the snapshot to evaluate for possible node configurations.
     * </p>
     * 
     * @return The identifier of the snapshot to evaluate for possible node configurations.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot associated with the message to describe node configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot associated with the message to describe node
     *         configuration.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you
     * do not own, optional if you own the snapshot.
     * </p>
     * 
     * @return The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a
     *         snapshot you do not own, optional if you own the snapshot.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of name, operator, and value items to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A set of name, operator, and value items to filter the results.
     */
    public final List<NodeConfigurationOptionsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon
     * Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     * request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>500</code>
     * </p>
     * <p>
     * Constraints: minimum 100, maximum 500.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>500</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 100, maximum 500.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeNodeConfigurationOptionsRequest other = (DescribeNodeConfigurationOptionsRequest) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotArn(), other.snapshotArn()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNodeConfigurationOptionsRequest").add("ActionType", actionTypeAsString())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("SnapshotArn", snapshotArn()).add("OwnerAccount", ownerAccount())
                .add("Filters", hasFilters() ? filters() : null).add("Marker", marker()).add("MaxRecords", maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNodeConfigurationOptionsRequest> {
        /**
         * <p>
         * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
         * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration
         * recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration
         * combinations for elastic resize based on an existing cluster.
         * </p>
         * 
         * @param actionType
         *        The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
         *        configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
         *        configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to
         *        get configuration combinations for elastic resize based on an existing cluster.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
         * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration
         * recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration
         * combinations for elastic resize based on an existing cluster.
         * </p>
         * 
         * @param actionType
         *        The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
         *        configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
         *        configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to
         *        get configuration combinations for elastic resize based on an existing cluster.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The identifier of the cluster to evaluate for possible node configurations.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster to evaluate for possible node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the snapshot to evaluate for possible node configurations.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot to evaluate for possible node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot associated with the message to describe node configuration.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) of the snapshot associated with the message to describe node
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot
         * you do not own, optional if you own the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a
         *        snapshot you do not own, optional if you own the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * 
         * @param filters
         *        A set of name, operator, and value items to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<NodeConfigurationOptionsFilter> filters);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * 
         * @param filters
         *        A set of name, operator, and value items to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(NodeConfigurationOptionsFilter... filters);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<NodeConfigurationOptionsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<NodeConfigurationOptionsFilter>)
         */
        Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder>... filters);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>,
         * Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the
         * next set of response records by providing the returned marker value in the <code>Marker</code> parameter and
         * retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned marker value in
         *        the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>500</code>
         * </p>
         * <p>
         * Constraints: minimum 100, maximum 500.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>500</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 100, maximum 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String actionType;

        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String snapshotArn;

        private String ownerAccount;

        private List<NodeConfigurationOptionsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsRequest model) {
            super(model);
            actionType(model.actionType);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotArn(model.snapshotArn);
            ownerAccount(model.ownerAccount);
            filters(model.filters);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final List<NodeConfigurationOptionsFilter.Builder> getFilters() {
            List<NodeConfigurationOptionsFilter.Builder> result = NodeConfigurationOptionsFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<NodeConfigurationOptionsFilter.BuilderImpl> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<NodeConfigurationOptionsFilter> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(NodeConfigurationOptionsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> NodeConfigurationOptionsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNodeConfigurationOptionsRequest build() {
            return new DescribeNodeConfigurationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
