/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomDomainAssociationsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeCustomDomainAssociationsRequest.Builder, DescribeCustomDomainAssociationsRequest> {
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainName").getter(getter(DescribeCustomDomainAssociationsRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomDomainCertificateArn")
            .getter(getter(DescribeCustomDomainAssociationsRequest::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateArn").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeCustomDomainAssociationsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCustomDomainAssociationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOMAIN_NAME_FIELD,
            CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String customDomainName;

    private final String customDomainCertificateArn;

    private final Integer maxRecords;

    private final String marker;

    private DescribeCustomDomainAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.customDomainName = builder.customDomainName;
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The custom domain name for the custom domain association.
     * </p>
     * 
     * @return The custom domain name for the custom domain association.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The certificate Amazon Resource Name (ARN) for the custom domain association.
     * </p>
     * 
     * @return The certificate Amazon Resource Name (ARN) for the custom domain association.
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The maximum records setting for the associated custom domain.
     * </p>
     * 
     * @return The maximum records setting for the associated custom domain.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The marker for the custom domain association.
     * </p>
     * 
     * @return The marker for the custom domain association.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomDomainAssociationsRequest)) {
            return false;
        }
        DescribeCustomDomainAssociationsRequest other = (DescribeCustomDomainAssociationsRequest) obj;
        return Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomDomainAssociationsRequest").add("CustomDomainName", customDomainName())
                .add("CustomDomainCertificateArn", customDomainCertificateArn()).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "CustomDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomDomainAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeCustomDomainAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomDomainAssociationsRequest> {
        /**
         * <p>
         * The custom domain name for the custom domain association.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name for the custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The certificate Amazon Resource Name (ARN) for the custom domain association.
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The certificate Amazon Resource Name (ARN) for the custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The maximum records setting for the associated custom domain.
         * </p>
         * 
         * @param maxRecords
         *        The maximum records setting for the associated custom domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The marker for the custom domain association.
         * </p>
         * 
         * @param marker
         *        The marker for the custom domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String customDomainName;

        private String customDomainCertificateArn;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomDomainAssociationsRequest model) {
            super(model);
            customDomainName(model.customDomainName);
            customDomainCertificateArn(model.customDomainCertificateArn);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCustomDomainAssociationsRequest build() {
            return new DescribeCustomDomainAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
