/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRedshiftIdcApplicationRequest extends RedshiftRequest implements
        ToCopyableBuilder<DeleteRedshiftIdcApplicationRequest.Builder, DeleteRedshiftIdcApplicationRequest> {
    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedshiftIdcApplicationArn")
            .getter(getter(DeleteRedshiftIdcApplicationRequest::redshiftIdcApplicationArn))
            .setter(setter(Builder::redshiftIdcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REDSHIFT_IDC_APPLICATION_ARN_FIELD));

    private final String redshiftIdcApplicationArn;

    private DeleteRedshiftIdcApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.redshiftIdcApplicationArn = builder.redshiftIdcApplicationArn;
    }

    /**
     * <p>
     * The ARN for a deleted Amazon Redshift IAM Identity Center application.
     * </p>
     * 
     * @return The ARN for a deleted Amazon Redshift IAM Identity Center application.
     */
    public final String redshiftIdcApplicationArn() {
        return redshiftIdcApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(redshiftIdcApplicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRedshiftIdcApplicationRequest)) {
            return false;
        }
        DeleteRedshiftIdcApplicationRequest other = (DeleteRedshiftIdcApplicationRequest) obj;
        return Objects.equals(redshiftIdcApplicationArn(), other.redshiftIdcApplicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRedshiftIdcApplicationRequest")
                .add("RedshiftIdcApplicationArn", redshiftIdcApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftIdcApplicationArn":
            return Optional.ofNullable(clazz.cast(redshiftIdcApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRedshiftIdcApplicationRequest, T> g) {
        return obj -> g.apply((DeleteRedshiftIdcApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRedshiftIdcApplicationRequest> {
        /**
         * <p>
         * The ARN for a deleted Amazon Redshift IAM Identity Center application.
         * </p>
         * 
         * @param redshiftIdcApplicationArn
         *        The ARN for a deleted Amazon Redshift IAM Identity Center application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String redshiftIdcApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRedshiftIdcApplicationRequest model) {
            super(model);
            redshiftIdcApplicationArn(model.redshiftIdcApplicationArn);
        }

        public final String getRedshiftIdcApplicationArn() {
            return redshiftIdcApplicationArn;
        }

        public final void setRedshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
        }

        @Override
        public final Builder redshiftIdcApplicationArn(String redshiftIdcApplicationArn) {
            this.redshiftIdcApplicationArn = redshiftIdcApplicationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRedshiftIdcApplicationRequest build() {
            return new DeleteRedshiftIdcApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
