/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.UsageLimit;

public class DescribeUsageLimitsIterable
implements SdkIterable<DescribeUsageLimitsResponse> {
    private final RedshiftClient client;
    private final DescribeUsageLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeUsageLimitsIterable(RedshiftClient client, DescribeUsageLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeUsageLimitsResponseFetcher();
    }

    public Iterator<DescribeUsageLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsageLimit> usageLimits() {
        Function<DescribeUsageLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.usageLimits() != null) {
                return response.usageLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeUsageLimitsResponseFetcher
    implements SyncPageFetcher<DescribeUsageLimitsResponse> {
        private DescribeUsageLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsageLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeUsageLimitsResponse nextPage(DescribeUsageLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsageLimitsIterable.this.client.describeUsageLimits(DescribeUsageLimitsIterable.this.firstRequest);
            }
            return DescribeUsageLimitsIterable.this.client.describeUsageLimits((DescribeUsageLimitsRequest)((Object)DescribeUsageLimitsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

