/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOption;

public class DescribeNodeConfigurationOptionsIterable
implements SdkIterable<DescribeNodeConfigurationOptionsResponse> {
    private final RedshiftClient client;
    private final DescribeNodeConfigurationOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNodeConfigurationOptionsIterable(RedshiftClient client, DescribeNodeConfigurationOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNodeConfigurationOptionsResponseFetcher();
    }

    public Iterator<DescribeNodeConfigurationOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NodeConfigurationOption> nodeConfigurationOptionList() {
        Function<DescribeNodeConfigurationOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodeConfigurationOptionList() != null) {
                return response.nodeConfigurationOptionList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNodeConfigurationOptionsResponseFetcher
    implements SyncPageFetcher<DescribeNodeConfigurationOptionsResponse> {
        private DescribeNodeConfigurationOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNodeConfigurationOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeNodeConfigurationOptionsResponse nextPage(DescribeNodeConfigurationOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNodeConfigurationOptionsIterable.this.client.describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsIterable.this.firstRequest);
            }
            return DescribeNodeConfigurationOptionsIterable.this.client.describeNodeConfigurationOptions((DescribeNodeConfigurationOptionsRequest)((Object)DescribeNodeConfigurationOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

