/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeauthorizeDataShareResponse extends RedshiftResponse implements
        ToCopyableBuilder<DeauthorizeDataShareResponse.Builder, DeauthorizeDataShareResponse> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataShareArn").getter(getter(DeauthorizeDataShareResponse::dataShareArn))
            .setter(setter(Builder::dataShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()).build();

    private static final SdkField<String> PRODUCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProducerArn").getter(getter(DeauthorizeDataShareResponse::producerArn))
            .setter(setter(Builder::producerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerArn").build()).build();

    private static final SdkField<Boolean> ALLOW_PUBLICLY_ACCESSIBLE_CONSUMERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowPubliclyAccessibleConsumers")
            .getter(getter(DeauthorizeDataShareResponse::allowPubliclyAccessibleConsumers))
            .setter(setter(Builder::allowPubliclyAccessibleConsumers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowPubliclyAccessibleConsumers")
                    .build()).build();

    private static final SdkField<List<DataShareAssociation>> DATA_SHARE_ASSOCIATIONS_FIELD = SdkField
            .<List<DataShareAssociation>> builder(MarshallingType.LIST)
            .memberName("DataShareAssociations")
            .getter(getter(DeauthorizeDataShareResponse::dataShareAssociations))
            .setter(setter(Builder::dataShareAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataShareAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataShareAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedBy").getter(getter(DeauthorizeDataShareResponse::managedBy)).setter(setter(Builder::managedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD,
            PRODUCER_ARN_FIELD, ALLOW_PUBLICLY_ACCESSIBLE_CONSUMERS_FIELD, DATA_SHARE_ASSOCIATIONS_FIELD, MANAGED_BY_FIELD));

    private final String dataShareArn;

    private final String producerArn;

    private final Boolean allowPubliclyAccessibleConsumers;

    private final List<DataShareAssociation> dataShareAssociations;

    private final String managedBy;

    private DeauthorizeDataShareResponse(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.producerArn = builder.producerArn;
        this.allowPubliclyAccessibleConsumers = builder.allowPubliclyAccessibleConsumers;
        this.dataShareAssociations = builder.dataShareAssociations;
        this.managedBy = builder.managedBy;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer
     * cluster. A datashare ARN is in the
     * <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the
     *         producer cluster. A datashare ARN is in the
     *         <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.
     */
    public final String dataShareArn() {
        return dataShareArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the producer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the producer.
     */
    public final String producerArn() {
        return producerArn;
    }

    /**
     * <p>
     * A value that specifies whether the datashare can be shared to a publicly accessible cluster.
     * </p>
     * 
     * @return A value that specifies whether the datashare can be shared to a publicly accessible cluster.
     */
    public final Boolean allowPubliclyAccessibleConsumers() {
        return allowPubliclyAccessibleConsumers;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataShareAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataShareAssociations() {
        return dataShareAssociations != null && !(dataShareAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A value that specifies when the datashare has an association between producer and data consumers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataShareAssociations} method.
     * </p>
     * 
     * @return A value that specifies when the datashare has an association between producer and data consumers.
     */
    public final List<DataShareAssociation> dataShareAssociations() {
        return dataShareAssociations;
    }

    /**
     * <p>
     * The identifier of a datashare to show its managing entity.
     * </p>
     * 
     * @return The identifier of a datashare to show its managing entity.
     */
    public final String managedBy() {
        return managedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(producerArn());
        hashCode = 31 * hashCode + Objects.hashCode(allowPubliclyAccessibleConsumers());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataShareAssociations() ? dataShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeauthorizeDataShareResponse)) {
            return false;
        }
        DeauthorizeDataShareResponse other = (DeauthorizeDataShareResponse) obj;
        return Objects.equals(dataShareArn(), other.dataShareArn()) && Objects.equals(producerArn(), other.producerArn())
                && Objects.equals(allowPubliclyAccessibleConsumers(), other.allowPubliclyAccessibleConsumers())
                && hasDataShareAssociations() == other.hasDataShareAssociations()
                && Objects.equals(dataShareAssociations(), other.dataShareAssociations())
                && Objects.equals(managedBy(), other.managedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeauthorizeDataShareResponse").add("DataShareArn", dataShareArn())
                .add("ProducerArn", producerArn()).add("AllowPubliclyAccessibleConsumers", allowPubliclyAccessibleConsumers())
                .add("DataShareAssociations", hasDataShareAssociations() ? dataShareAssociations() : null)
                .add("ManagedBy", managedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShareArn":
            return Optional.ofNullable(clazz.cast(dataShareArn()));
        case "ProducerArn":
            return Optional.ofNullable(clazz.cast(producerArn()));
        case "AllowPubliclyAccessibleConsumers":
            return Optional.ofNullable(clazz.cast(allowPubliclyAccessibleConsumers()));
        case "DataShareAssociations":
            return Optional.ofNullable(clazz.cast(dataShareAssociations()));
        case "ManagedBy":
            return Optional.ofNullable(clazz.cast(managedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeauthorizeDataShareResponse, T> g) {
        return obj -> g.apply((DeauthorizeDataShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeauthorizeDataShareResponse> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the
         * producer cluster. A datashare ARN is in the
         * <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.
         * </p>
         * 
         * @param dataShareArn
         *        An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of
         *        the producer cluster. A datashare ARN is in the
         *        <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareArn(String dataShareArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the producer.
         * </p>
         * 
         * @param producerArn
         *        The Amazon Resource Name (ARN) of the producer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder producerArn(String producerArn);

        /**
         * <p>
         * A value that specifies whether the datashare can be shared to a publicly accessible cluster.
         * </p>
         * 
         * @param allowPubliclyAccessibleConsumers
         *        A value that specifies whether the datashare can be shared to a publicly accessible cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers);

        /**
         * <p>
         * A value that specifies when the datashare has an association between producer and data consumers.
         * </p>
         * 
         * @param dataShareAssociations
         *        A value that specifies when the datashare has an association between producer and data consumers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareAssociations(Collection<DataShareAssociation> dataShareAssociations);

        /**
         * <p>
         * A value that specifies when the datashare has an association between producer and data consumers.
         * </p>
         * 
         * @param dataShareAssociations
         *        A value that specifies when the datashare has an association between producer and data consumers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareAssociations(DataShareAssociation... dataShareAssociations);

        /**
         * <p>
         * A value that specifies when the datashare has an association between producer and data consumers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.DataShareAssociation.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.redshift.model.DataShareAssociation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.DataShareAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #dataShareAssociations(List<DataShareAssociation>)}.
         * 
         * @param dataShareAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.DataShareAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataShareAssociations(java.util.Collection<DataShareAssociation>)
         */
        Builder dataShareAssociations(Consumer<DataShareAssociation.Builder>... dataShareAssociations);

        /**
         * <p>
         * The identifier of a datashare to show its managing entity.
         * </p>
         * 
         * @param managedBy
         *        The identifier of a datashare to show its managing entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedBy(String managedBy);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String dataShareArn;

        private String producerArn;

        private Boolean allowPubliclyAccessibleConsumers;

        private List<DataShareAssociation> dataShareAssociations = DefaultSdkAutoConstructList.getInstance();

        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeauthorizeDataShareResponse model) {
            super(model);
            dataShareArn(model.dataShareArn);
            producerArn(model.producerArn);
            allowPubliclyAccessibleConsumers(model.allowPubliclyAccessibleConsumers);
            dataShareAssociations(model.dataShareAssociations);
            managedBy(model.managedBy);
        }

        public final String getDataShareArn() {
            return dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final String getProducerArn() {
            return producerArn;
        }

        public final void setProducerArn(String producerArn) {
            this.producerArn = producerArn;
        }

        @Override
        public final Builder producerArn(String producerArn) {
            this.producerArn = producerArn;
            return this;
        }

        public final Boolean getAllowPubliclyAccessibleConsumers() {
            return allowPubliclyAccessibleConsumers;
        }

        public final void setAllowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
            this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers;
        }

        @Override
        public final Builder allowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
            this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers;
            return this;
        }

        public final List<DataShareAssociation.Builder> getDataShareAssociations() {
            List<DataShareAssociation.Builder> result = DataShareAssociationListCopier.copyToBuilder(this.dataShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataShareAssociations(Collection<DataShareAssociation.BuilderImpl> dataShareAssociations) {
            this.dataShareAssociations = DataShareAssociationListCopier.copyFromBuilder(dataShareAssociations);
        }

        @Override
        public final Builder dataShareAssociations(Collection<DataShareAssociation> dataShareAssociations) {
            this.dataShareAssociations = DataShareAssociationListCopier.copy(dataShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShareAssociations(DataShareAssociation... dataShareAssociations) {
            dataShareAssociations(Arrays.asList(dataShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShareAssociations(Consumer<DataShareAssociation.Builder>... dataShareAssociations) {
            dataShareAssociations(Stream.of(dataShareAssociations)
                    .map(c -> DataShareAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getManagedBy() {
            return managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public DeauthorizeDataShareResponse build() {
            return new DeauthorizeDataShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
