/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshift.DefaultRedshiftBaseClientBuilder;
import software.amazon.awssdk.services.redshift.DefaultRedshiftClient;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.RedshiftClientBuilder;
import software.amazon.awssdk.services.redshift.RedshiftServiceClientConfiguration;
import software.amazon.awssdk.services.redshift.endpoints.RedshiftEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftClientBuilder
extends DefaultRedshiftBaseClientBuilder<RedshiftClientBuilder, RedshiftClient>
implements RedshiftClientBuilder {
    DefaultRedshiftClientBuilder() {
    }

    @Override
    public DefaultRedshiftClientBuilder endpointProvider(RedshiftEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRedshiftClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RedshiftServiceClientConfiguration serviceClientConfiguration = RedshiftServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRedshiftClient(serviceClientConfiguration, clientConfiguration);
    }
}

