/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse;

public class DescribeDataSharesForConsumerIterable
implements SdkIterable<DescribeDataSharesForConsumerResponse> {
    private final RedshiftClient client;
    private final DescribeDataSharesForConsumerRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataSharesForConsumerIterable(RedshiftClient client, DescribeDataSharesForConsumerRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDataSharesForConsumerResponseFetcher();
    }

    public Iterator<DescribeDataSharesForConsumerResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataShare> dataShares() {
        Function<DescribeDataSharesForConsumerResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataShares() != null) {
                return response.dataShares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDataSharesForConsumerResponseFetcher
    implements SyncPageFetcher<DescribeDataSharesForConsumerResponse> {
        private DescribeDataSharesForConsumerResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesForConsumerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDataSharesForConsumerResponse nextPage(DescribeDataSharesForConsumerResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesForConsumerIterable.this.client.describeDataSharesForConsumer(DescribeDataSharesForConsumerIterable.this.firstRequest);
            }
            return DescribeDataSharesForConsumerIterable.this.client.describeDataSharesForConsumer((DescribeDataSharesForConsumerRequest)((Object)DescribeDataSharesForConsumerIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

