/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse;

public class DescribeDataSharesPublisher
implements SdkPublisher<DescribeDataSharesResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeDataSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataSharesPublisher(RedshiftAsyncClient client, DescribeDataSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataSharesPublisher(RedshiftAsyncClient client, DescribeDataSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataShare> dataShares() {
        Function<DescribeDataSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataShares() != null) {
                return response.dataShares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDataSharesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDataSharesResponseFetcher
    implements AsyncPageFetcher<DescribeDataSharesResponse> {
        private DescribeDataSharesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDataSharesResponse> nextPage(DescribeDataSharesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesPublisher.this.client.describeDataShares(DescribeDataSharesPublisher.this.firstRequest);
            }
            return DescribeDataSharesPublisher.this.client.describeDataShares((DescribeDataSharesRequest)((Object)DescribeDataSharesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

