/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePartnerStatusResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, UpdatePartnerStatusResponse> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(UpdatePartnerStatusResponse.getter(UpdatePartnerStatusResponse::databaseName)).setter(UpdatePartnerStatusResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerName").getter(UpdatePartnerStatusResponse.getter(UpdatePartnerStatusResponse::partnerName)).setter(UpdatePartnerStatusResponse.setter(Builder::partnerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, PARTNER_NAME_FIELD));
    private final String databaseName;
    private final String partnerName;

    private UpdatePartnerStatusResponse(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.partnerName = builder.partnerName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String partnerName() {
        return this.partnerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnerStatusResponse)) {
            return false;
        }
        UpdatePartnerStatusResponse other = (UpdatePartnerStatusResponse)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.partnerName(), other.partnerName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePartnerStatusResponse").add("DatabaseName", (Object)this.databaseName()).add("PartnerName", (Object)this.partnerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "PartnerName": {
                return Optional.ofNullable(clazz.cast(this.partnerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnerStatusResponse, T> g) {
        return obj -> g.apply((UpdatePartnerStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String databaseName;
        private String partnerName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnerStatusResponse model) {
            super(model);
            this.databaseName(model.databaseName);
            this.partnerName(model.partnerName);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getPartnerName() {
            return this.partnerName;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        @Override
        @Transient
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        @Override
        public UpdatePartnerStatusResponse build() {
            return new UpdatePartnerStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePartnerStatusResponse> {
        public Builder databaseName(String var1);

        public Builder partnerName(String var1);
    }
}

