/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatus;

public class DescribeTableRestoreStatusIterable
implements SdkIterable<DescribeTableRestoreStatusResponse> {
    private final RedshiftClient client;
    private final DescribeTableRestoreStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTableRestoreStatusIterable(RedshiftClient client, DescribeTableRestoreStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTableRestoreStatusResponseFetcher();
    }

    public Iterator<DescribeTableRestoreStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableRestoreStatus> tableRestoreStatusDetails() {
        Function<DescribeTableRestoreStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableRestoreStatusDetails() != null) {
                return response.tableRestoreStatusDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTableRestoreStatusResponseFetcher
    implements SyncPageFetcher<DescribeTableRestoreStatusResponse> {
        private DescribeTableRestoreStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableRestoreStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTableRestoreStatusResponse nextPage(DescribeTableRestoreStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeTableRestoreStatusIterable.this.client.describeTableRestoreStatus(DescribeTableRestoreStatusIterable.this.firstRequest);
            }
            return DescribeTableRestoreStatusIterable.this.client.describeTableRestoreStatus((DescribeTableRestoreStatusRequest)((Object)DescribeTableRestoreStatusIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

