/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RevisionTarget;
import software.amazon.awssdk.services.redshift.model.RevisionTargetsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterDbRevision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterDbRevision> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ClusterDbRevision.getter(ClusterDbRevision::clusterIdentifier)).setter(ClusterDbRevision.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> CURRENT_DATABASE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentDatabaseRevision").getter(ClusterDbRevision.getter(ClusterDbRevision::currentDatabaseRevision)).setter(ClusterDbRevision.setter(Builder::currentDatabaseRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentDatabaseRevision").build()}).build();
    private static final SdkField<Instant> DATABASE_REVISION_RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DatabaseRevisionReleaseDate").getter(ClusterDbRevision.getter(ClusterDbRevision::databaseRevisionReleaseDate)).setter(ClusterDbRevision.setter(Builder::databaseRevisionReleaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseRevisionReleaseDate").build()}).build();
    private static final SdkField<List<RevisionTarget>> REVISION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevisionTargets").getter(ClusterDbRevision.getter(ClusterDbRevision::revisionTargets)).setter(ClusterDbRevision.setter(Builder::revisionTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionTargets").build(), ListTrait.builder().memberLocationName("RevisionTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionTarget").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CURRENT_DATABASE_REVISION_FIELD, DATABASE_REVISION_RELEASE_DATE_FIELD, REVISION_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterIdentifier;
    private final String currentDatabaseRevision;
    private final Instant databaseRevisionReleaseDate;
    private final List<RevisionTarget> revisionTargets;

    private ClusterDbRevision(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.currentDatabaseRevision = builder.currentDatabaseRevision;
        this.databaseRevisionReleaseDate = builder.databaseRevisionReleaseDate;
        this.revisionTargets = builder.revisionTargets;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String currentDatabaseRevision() {
        return this.currentDatabaseRevision;
    }

    public final Instant databaseRevisionReleaseDate() {
        return this.databaseRevisionReleaseDate;
    }

    public final boolean hasRevisionTargets() {
        return this.revisionTargets != null && !(this.revisionTargets instanceof SdkAutoConstructList);
    }

    public final List<RevisionTarget> revisionTargets() {
        return this.revisionTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDatabaseRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseRevisionReleaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisionTargets() ? this.revisionTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterDbRevision)) {
            return false;
        }
        ClusterDbRevision other = (ClusterDbRevision)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.currentDatabaseRevision(), other.currentDatabaseRevision()) && Objects.equals(this.databaseRevisionReleaseDate(), other.databaseRevisionReleaseDate()) && this.hasRevisionTargets() == other.hasRevisionTargets() && Objects.equals(this.revisionTargets(), other.revisionTargets());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterDbRevision").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("CurrentDatabaseRevision", (Object)this.currentDatabaseRevision()).add("DatabaseRevisionReleaseDate", (Object)this.databaseRevisionReleaseDate()).add("RevisionTargets", this.hasRevisionTargets() ? this.revisionTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "CurrentDatabaseRevision": {
                return Optional.ofNullable(clazz.cast(this.currentDatabaseRevision()));
            }
            case "DatabaseRevisionReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.databaseRevisionReleaseDate()));
            }
            case "RevisionTargets": {
                return Optional.ofNullable(clazz.cast(this.revisionTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterDbRevision, T> g) {
        return obj -> g.apply((ClusterDbRevision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String currentDatabaseRevision;
        private Instant databaseRevisionReleaseDate;
        private List<RevisionTarget> revisionTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterDbRevision model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.currentDatabaseRevision(model.currentDatabaseRevision);
            this.databaseRevisionReleaseDate(model.databaseRevisionReleaseDate);
            this.revisionTargets(model.revisionTargets);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getCurrentDatabaseRevision() {
            return this.currentDatabaseRevision;
        }

        public final void setCurrentDatabaseRevision(String currentDatabaseRevision) {
            this.currentDatabaseRevision = currentDatabaseRevision;
        }

        @Override
        public final Builder currentDatabaseRevision(String currentDatabaseRevision) {
            this.currentDatabaseRevision = currentDatabaseRevision;
            return this;
        }

        public final Instant getDatabaseRevisionReleaseDate() {
            return this.databaseRevisionReleaseDate;
        }

        public final void setDatabaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
        }

        @Override
        public final Builder databaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
            return this;
        }

        public final List<RevisionTarget.Builder> getRevisionTargets() {
            List<RevisionTarget.Builder> result = RevisionTargetsListCopier.copyToBuilder(this.revisionTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisionTargets(Collection<RevisionTarget.BuilderImpl> revisionTargets) {
            this.revisionTargets = RevisionTargetsListCopier.copyFromBuilder(revisionTargets);
        }

        @Override
        public final Builder revisionTargets(Collection<RevisionTarget> revisionTargets) {
            this.revisionTargets = RevisionTargetsListCopier.copy(revisionTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionTargets(RevisionTarget ... revisionTargets) {
            this.revisionTargets(Arrays.asList(revisionTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionTargets(Consumer<RevisionTarget.Builder> ... revisionTargets) {
            this.revisionTargets(Stream.of(revisionTargets).map(c -> (RevisionTarget)((RevisionTarget.Builder)RevisionTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterDbRevision build() {
            return new ClusterDbRevision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterDbRevision> {
        public Builder clusterIdentifier(String var1);

        public Builder currentDatabaseRevision(String var1);

        public Builder databaseRevisionReleaseDate(Instant var1);

        public Builder revisionTargets(Collection<RevisionTarget> var1);

        public Builder revisionTargets(RevisionTarget ... var1);

        public Builder revisionTargets(Consumer<RevisionTarget.Builder> ... var1);
    }
}

