/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorization;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationsCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointAuthorizationResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeEndpointAuthorizationResponse> {
    private static final SdkField<List<EndpointAuthorization>> ENDPOINT_AUTHORIZATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointAuthorizationList").getter(DescribeEndpointAuthorizationResponse.getter(DescribeEndpointAuthorizationResponse::endpointAuthorizationList)).setter(DescribeEndpointAuthorizationResponse.setter(Builder::endpointAuthorizationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAuthorizationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointAuthorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEndpointAuthorizationResponse.getter(DescribeEndpointAuthorizationResponse::marker)).setter(DescribeEndpointAuthorizationResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_AUTHORIZATION_LIST_FIELD, MARKER_FIELD));
    private final List<EndpointAuthorization> endpointAuthorizationList;
    private final String marker;

    private DescribeEndpointAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAuthorizationList = builder.endpointAuthorizationList;
        this.marker = builder.marker;
    }

    public final boolean hasEndpointAuthorizationList() {
        return this.endpointAuthorizationList != null && !(this.endpointAuthorizationList instanceof SdkAutoConstructList);
    }

    public final List<EndpointAuthorization> endpointAuthorizationList() {
        return this.endpointAuthorizationList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointAuthorizationList() ? this.endpointAuthorizationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointAuthorizationResponse)) {
            return false;
        }
        DescribeEndpointAuthorizationResponse other = (DescribeEndpointAuthorizationResponse)((Object)obj);
        return this.hasEndpointAuthorizationList() == other.hasEndpointAuthorizationList() && Objects.equals(this.endpointAuthorizationList(), other.endpointAuthorizationList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointAuthorizationResponse").add("EndpointAuthorizationList", this.hasEndpointAuthorizationList() ? this.endpointAuthorizationList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointAuthorizationList": {
                return Optional.ofNullable(clazz.cast(this.endpointAuthorizationList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointAuthorizationResponse, T> g) {
        return obj -> g.apply((DescribeEndpointAuthorizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<EndpointAuthorization> endpointAuthorizationList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointAuthorizationResponse model) {
            super(model);
            this.endpointAuthorizationList(model.endpointAuthorizationList);
            this.marker(model.marker);
        }

        public final List<EndpointAuthorization.Builder> getEndpointAuthorizationList() {
            List<EndpointAuthorization.Builder> result = EndpointAuthorizationsCopier.copyToBuilder(this.endpointAuthorizationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointAuthorizationList(Collection<EndpointAuthorization.BuilderImpl> endpointAuthorizationList) {
            this.endpointAuthorizationList = EndpointAuthorizationsCopier.copyFromBuilder(endpointAuthorizationList);
        }

        @Override
        @Transient
        public final Builder endpointAuthorizationList(Collection<EndpointAuthorization> endpointAuthorizationList) {
            this.endpointAuthorizationList = EndpointAuthorizationsCopier.copy(endpointAuthorizationList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointAuthorizationList(EndpointAuthorization ... endpointAuthorizationList) {
            this.endpointAuthorizationList(Arrays.asList(endpointAuthorizationList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointAuthorizationList(Consumer<EndpointAuthorization.Builder> ... endpointAuthorizationList) {
            this.endpointAuthorizationList(Stream.of(endpointAuthorizationList).map(c -> (EndpointAuthorization)((EndpointAuthorization.Builder)EndpointAuthorization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeEndpointAuthorizationResponse build() {
            return new DescribeEndpointAuthorizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointAuthorizationResponse> {
        public Builder endpointAuthorizationList(Collection<EndpointAuthorization> var1);

        public Builder endpointAuthorizationList(EndpointAuthorization ... var1);

        public Builder endpointAuthorizationList(Consumer<EndpointAuthorization.Builder> ... var1);

        public Builder marker(String var1);
    }
}

