/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AuthorizationStatus;
import software.amazon.awssdk.services.redshift.model.VpcIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointAuthorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointAuthorization> {
    private static final SdkField<String> GRANTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Grantor").getter(EndpointAuthorization.getter(EndpointAuthorization::grantor)).setter(EndpointAuthorization.setter(Builder::grantor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantor").build()}).build();
    private static final SdkField<String> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Grantee").getter(EndpointAuthorization.getter(EndpointAuthorization::grantee)).setter(EndpointAuthorization.setter(Builder::grantee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(EndpointAuthorization.getter(EndpointAuthorization::clusterIdentifier)).setter(EndpointAuthorization.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Instant> AUTHORIZE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AuthorizeTime").getter(EndpointAuthorization.getter(EndpointAuthorization::authorizeTime)).setter(EndpointAuthorization.setter(Builder::authorizeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizeTime").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterStatus").getter(EndpointAuthorization.getter(EndpointAuthorization::clusterStatus)).setter(EndpointAuthorization.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EndpointAuthorization.getter(EndpointAuthorization::statusAsString)).setter(EndpointAuthorization.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> ALLOWED_ALL_VP_CS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowedAllVPCs").getter(EndpointAuthorization.getter(EndpointAuthorization::allowedAllVPCs)).setter(EndpointAuthorization.setter(Builder::allowedAllVPCs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAllVPCs").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VP_CS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedVPCs").getter(EndpointAuthorization.getter(EndpointAuthorization::allowedVPCs)).setter(EndpointAuthorization.setter(Builder::allowedVPCs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedVPCs").build(), ListTrait.builder().memberLocationName("VpcIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIdentifier").build()}).build()).build()}).build();
    private static final SdkField<Integer> ENDPOINT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndpointCount").getter(EndpointAuthorization.getter(EndpointAuthorization::endpointCount)).setter(EndpointAuthorization.setter(Builder::endpointCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTOR_FIELD, GRANTEE_FIELD, CLUSTER_IDENTIFIER_FIELD, AUTHORIZE_TIME_FIELD, CLUSTER_STATUS_FIELD, STATUS_FIELD, ALLOWED_ALL_VP_CS_FIELD, ALLOWED_VP_CS_FIELD, ENDPOINT_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String grantor;
    private final String grantee;
    private final String clusterIdentifier;
    private final Instant authorizeTime;
    private final String clusterStatus;
    private final String status;
    private final Boolean allowedAllVPCs;
    private final List<String> allowedVPCs;
    private final Integer endpointCount;

    private EndpointAuthorization(BuilderImpl builder) {
        this.grantor = builder.grantor;
        this.grantee = builder.grantee;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.authorizeTime = builder.authorizeTime;
        this.clusterStatus = builder.clusterStatus;
        this.status = builder.status;
        this.allowedAllVPCs = builder.allowedAllVPCs;
        this.allowedVPCs = builder.allowedVPCs;
        this.endpointCount = builder.endpointCount;
    }

    public final String grantor() {
        return this.grantor;
    }

    public final String grantee() {
        return this.grantee;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Instant authorizeTime() {
        return this.authorizeTime;
    }

    public final String clusterStatus() {
        return this.clusterStatus;
    }

    public final AuthorizationStatus status() {
        return AuthorizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean allowedAllVPCs() {
        return this.allowedAllVPCs;
    }

    public final boolean hasAllowedVPCs() {
        return this.allowedVPCs != null && !(this.allowedVPCs instanceof SdkAutoConstructList);
    }

    public final List<String> allowedVPCs() {
        return this.allowedVPCs;
    }

    public final Integer endpointCount() {
        return this.endpointCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantor());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedAllVPCs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedVPCs() ? this.allowedVPCs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAuthorization)) {
            return false;
        }
        EndpointAuthorization other = (EndpointAuthorization)obj;
        return Objects.equals(this.grantor(), other.grantor()) && Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.authorizeTime(), other.authorizeTime()) && Objects.equals(this.clusterStatus(), other.clusterStatus()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.allowedAllVPCs(), other.allowedAllVPCs()) && this.hasAllowedVPCs() == other.hasAllowedVPCs() && Objects.equals(this.allowedVPCs(), other.allowedVPCs()) && Objects.equals(this.endpointCount(), other.endpointCount());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointAuthorization").add("Grantor", (Object)this.grantor()).add("Grantee", (Object)this.grantee()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("AuthorizeTime", (Object)this.authorizeTime()).add("ClusterStatus", (Object)this.clusterStatus()).add("Status", (Object)this.statusAsString()).add("AllowedAllVPCs", (Object)this.allowedAllVPCs()).add("AllowedVPCs", this.hasAllowedVPCs() ? this.allowedVPCs() : null).add("EndpointCount", (Object)this.endpointCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Grantor": {
                return Optional.ofNullable(clazz.cast(this.grantor()));
            }
            case "Grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "AuthorizeTime": {
                return Optional.ofNullable(clazz.cast(this.authorizeTime()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatus()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AllowedAllVPCs": {
                return Optional.ofNullable(clazz.cast(this.allowedAllVPCs()));
            }
            case "AllowedVPCs": {
                return Optional.ofNullable(clazz.cast(this.allowedVPCs()));
            }
            case "EndpointCount": {
                return Optional.ofNullable(clazz.cast(this.endpointCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointAuthorization, T> g) {
        return obj -> g.apply((EndpointAuthorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String grantor;
        private String grantee;
        private String clusterIdentifier;
        private Instant authorizeTime;
        private String clusterStatus;
        private String status;
        private Boolean allowedAllVPCs;
        private List<String> allowedVPCs = DefaultSdkAutoConstructList.getInstance();
        private Integer endpointCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointAuthorization model) {
            this.grantor(model.grantor);
            this.grantee(model.grantee);
            this.clusterIdentifier(model.clusterIdentifier);
            this.authorizeTime(model.authorizeTime);
            this.clusterStatus(model.clusterStatus);
            this.status(model.status);
            this.allowedAllVPCs(model.allowedAllVPCs);
            this.allowedVPCs(model.allowedVPCs);
            this.endpointCount(model.endpointCount);
        }

        public final String getGrantor() {
            return this.grantor;
        }

        public final void setGrantor(String grantor) {
            this.grantor = grantor;
        }

        @Override
        @Transient
        public final Builder grantor(String grantor) {
            this.grantor = grantor;
            return this;
        }

        public final String getGrantee() {
            return this.grantee;
        }

        public final void setGrantee(String grantee) {
            this.grantee = grantee;
        }

        @Override
        @Transient
        public final Builder grantee(String grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Instant getAuthorizeTime() {
            return this.authorizeTime;
        }

        public final void setAuthorizeTime(Instant authorizeTime) {
            this.authorizeTime = authorizeTime;
        }

        @Override
        @Transient
        public final Builder authorizeTime(Instant authorizeTime) {
            this.authorizeTime = authorizeTime;
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        @Transient
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AuthorizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getAllowedAllVPCs() {
            return this.allowedAllVPCs;
        }

        public final void setAllowedAllVPCs(Boolean allowedAllVPCs) {
            this.allowedAllVPCs = allowedAllVPCs;
        }

        @Override
        @Transient
        public final Builder allowedAllVPCs(Boolean allowedAllVPCs) {
            this.allowedAllVPCs = allowedAllVPCs;
            return this;
        }

        public final Collection<String> getAllowedVPCs() {
            if (this.allowedVPCs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedVPCs;
        }

        public final void setAllowedVPCs(Collection<String> allowedVPCs) {
            this.allowedVPCs = VpcIdentifierListCopier.copy(allowedVPCs);
        }

        @Override
        @Transient
        public final Builder allowedVPCs(Collection<String> allowedVPCs) {
            this.allowedVPCs = VpcIdentifierListCopier.copy(allowedVPCs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedVPCs(String ... allowedVPCs) {
            this.allowedVPCs(Arrays.asList(allowedVPCs));
            return this;
        }

        public final Integer getEndpointCount() {
            return this.endpointCount;
        }

        public final void setEndpointCount(Integer endpointCount) {
            this.endpointCount = endpointCount;
        }

        @Override
        @Transient
        public final Builder endpointCount(Integer endpointCount) {
            this.endpointCount = endpointCount;
            return this;
        }

        public EndpointAuthorization build() {
            return new EndpointAuthorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointAuthorization> {
        public Builder grantor(String var1);

        public Builder grantee(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder authorizeTime(Instant var1);

        public Builder clusterStatus(String var1);

        public Builder status(String var1);

        public Builder status(AuthorizationStatus var1);

        public Builder allowedAllVPCs(Boolean var1);

        public Builder allowedVPCs(Collection<String> var1);

        public Builder allowedVPCs(String ... var1);

        public Builder endpointCount(Integer var1);
    }
}

