/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse;

public class DescribeDataSharesForProducerIterable
implements SdkIterable<DescribeDataSharesForProducerResponse> {
    private final RedshiftClient client;
    private final DescribeDataSharesForProducerRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataSharesForProducerIterable(RedshiftClient client, DescribeDataSharesForProducerRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataSharesForProducerResponseFetcher();
    }

    public Iterator<DescribeDataSharesForProducerResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataShare> dataShares() {
        Function<DescribeDataSharesForProducerResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataShares() != null) {
                return response.dataShares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDataSharesForProducerResponseFetcher
    implements SyncPageFetcher<DescribeDataSharesForProducerResponse> {
        private DescribeDataSharesForProducerResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesForProducerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDataSharesForProducerResponse nextPage(DescribeDataSharesForProducerResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesForProducerIterable.this.client.describeDataSharesForProducer(DescribeDataSharesForProducerIterable.this.firstRequest);
            }
            return DescribeDataSharesForProducerIterable.this.client.describeDataSharesForProducer((DescribeDataSharesForProducerRequest)((Object)DescribeDataSharesForProducerIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

