/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableSnapshotCopyRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, EnableSnapshotCopyRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(EnableSnapshotCopyRequest.getter(EnableSnapshotCopyRequest::clusterIdentifier)).setter(EnableSnapshotCopyRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationRegion").getter(EnableSnapshotCopyRequest.getter(EnableSnapshotCopyRequest::destinationRegion)).setter(EnableSnapshotCopyRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriod").getter(EnableSnapshotCopyRequest.getter(EnableSnapshotCopyRequest::retentionPeriod)).setter(EnableSnapshotCopyRequest.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<String> SNAPSHOT_COPY_GRANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotCopyGrantName").getter(EnableSnapshotCopyRequest.getter(EnableSnapshotCopyRequest::snapshotCopyGrantName)).setter(EnableSnapshotCopyRequest.setter(Builder::snapshotCopyGrantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrantName").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(EnableSnapshotCopyRequest.getter(EnableSnapshotCopyRequest::manualSnapshotRetentionPeriod)).setter(EnableSnapshotCopyRequest.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DESTINATION_REGION_FIELD, RETENTION_PERIOD_FIELD, SNAPSHOT_COPY_GRANT_NAME_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD));
    private final String clusterIdentifier;
    private final String destinationRegion;
    private final Integer retentionPeriod;
    private final String snapshotCopyGrantName;
    private final Integer manualSnapshotRetentionPeriod;

    private EnableSnapshotCopyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public final String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public final Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSnapshotCopyRequest)) {
            return false;
        }
        EnableSnapshotCopyRequest other = (EnableSnapshotCopyRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snapshotCopyGrantName(), other.snapshotCopyGrantName()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"EnableSnapshotCopyRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DestinationRegion", (Object)this.destinationRegion()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnapshotCopyGrantName", (Object)this.snapshotCopyGrantName()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "SnapshotCopyGrantName": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrantName()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableSnapshotCopyRequest, T> g) {
        return obj -> g.apply((EnableSnapshotCopyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String destinationRegion;
        private Integer retentionPeriod;
        private String snapshotCopyGrantName;
        private Integer manualSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSnapshotCopyRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.destinationRegion(model.destinationRegion);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        @Transient
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        @Transient
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        @Override
        @Transient
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSnapshotCopyRequest build() {
            return new EnableSnapshotCopyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableSnapshotCopyRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder snapshotCopyGrantName(String var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

