/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.ClusterListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClustersResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClustersResponse.getter(DescribeClustersResponse::marker)).setter(DescribeClustersResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Cluster>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Clusters").getter(DescribeClustersResponse.getter(DescribeClustersResponse::clusters)).setter(DescribeClustersResponse.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(), ListTrait.builder().memberLocationName("Cluster").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cluster").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTERS_FIELD));
    private final String marker;
    private final List<Cluster> clusters;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusters = builder.clusters;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<Cluster> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClustersResponse").add("Marker", (Object)this.marker()).add("Clusters", this.hasClusters() ? this.clusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersResponse, T> g) {
        return obj -> g.apply((DescribeClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Cluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusters(model.clusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<Cluster.Builder> getClusters() {
            List<Cluster.Builder> result = ClusterListCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        @Transient
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusters(Consumer<Cluster.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (Cluster)((Cluster.Builder)Cluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder marker(String var1);

        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);

        public Builder clusters(Consumer<Cluster.Builder> ... var1);
    }
}

