/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotScheduleRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateSnapshotScheduleRequest> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleDefinitions").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::scheduleDefinitions)).setter(CreateSnapshotScheduleRequest.setter(Builder::scheduleDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(), ListTrait.builder().memberLocationName("ScheduleDefinition").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinition").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleIdentifier").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::scheduleIdentifier)).setter(CreateSnapshotScheduleRequest.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleDescription").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::scheduleDescription)).setter(CreateSnapshotScheduleRequest.setter(Builder::scheduleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::tags)).setter(CreateSnapshotScheduleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::dryRun)).setter(CreateSnapshotScheduleRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<Integer> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NextInvocations").getter(CreateSnapshotScheduleRequest.getter(CreateSnapshotScheduleRequest::nextInvocations)).setter(CreateSnapshotScheduleRequest.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD, SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, DRY_RUN_FIELD, NEXT_INVOCATIONS_FIELD));
    private final List<String> scheduleDefinitions;
    private final String scheduleIdentifier;
    private final String scheduleDescription;
    private final List<Tag> tags;
    private final Boolean dryRun;
    private final Integer nextInvocations;

    private CreateSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
        this.nextInvocations = builder.nextInvocations;
    }

    public final boolean hasScheduleDefinitions() {
        return this.scheduleDefinitions != null && !(this.scheduleDefinitions instanceof SdkAutoConstructList);
    }

    public final List<String> scheduleDefinitions() {
        return this.scheduleDefinitions;
    }

    public final String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public final String scheduleDescription() {
        return this.scheduleDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Integer nextInvocations() {
        return this.nextInvocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotScheduleRequest)) {
            return false;
        }
        CreateSnapshotScheduleRequest other = (CreateSnapshotScheduleRequest)((Object)obj);
        return this.hasScheduleDefinitions() == other.hasScheduleDefinitions() && Objects.equals(this.scheduleDefinitions(), other.scheduleDefinitions()) && Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && Objects.equals(this.scheduleDescription(), other.scheduleDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.nextInvocations(), other.nextInvocations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotScheduleRequest").add("ScheduleDefinitions", this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null).add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("ScheduleDescription", (Object)this.scheduleDescription()).add("Tags", this.hasTags() ? this.tags() : null).add("DryRun", (Object)this.dryRun()).add("NextInvocations", (Object)this.nextInvocations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleDefinitions": {
                return Optional.ofNullable(clazz.cast(this.scheduleDefinitions()));
            }
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "ScheduleDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduleDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((CreateSnapshotScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String scheduleIdentifier;
        private String scheduleDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private Integer nextInvocations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotScheduleRequest model) {
            super(model);
            this.scheduleDefinitions(model.scheduleDefinitions);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.scheduleDescription(model.scheduleDescription);
            this.tags(model.tags);
            this.dryRun(model.dryRun);
            this.nextInvocations(model.nextInvocations);
        }

        public final Collection<String> getScheduleDefinitions() {
            if (this.scheduleDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduleDefinitions;
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String ... scheduleDefinitions) {
            this.scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final String getScheduleDescription() {
            return this.scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        public final Integer getNextInvocations() {
            return this.nextInvocations;
        }

        @Override
        public final Builder nextInvocations(Integer nextInvocations) {
            this.nextInvocations = nextInvocations;
            return this;
        }

        public final void setNextInvocations(Integer nextInvocations) {
            this.nextInvocations = nextInvocations;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotScheduleRequest build() {
            return new CreateSnapshotScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotScheduleRequest> {
        public Builder scheduleDefinitions(Collection<String> var1);

        public Builder scheduleDefinitions(String ... var1);

        public Builder scheduleIdentifier(String var1);

        public Builder scheduleDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder nextInvocations(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

