/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TaggedResource;
import software.amazon.awssdk.services.redshift.model.TaggedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTagsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private static final SdkField<List<TaggedResource>> TAGGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaggedResources").getter(DescribeTagsResponse.getter(DescribeTagsResponse::taggedResources)).setter(DescribeTagsResponse.setter(Builder::taggedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaggedResources").build(), ListTrait.builder().memberLocationName("TaggedResource").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaggedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaggedResource").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTagsResponse.getter(DescribeTagsResponse::marker)).setter(DescribeTagsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGGED_RESOURCES_FIELD, MARKER_FIELD));
    private final List<TaggedResource> taggedResources;
    private final String marker;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.taggedResources = builder.taggedResources;
        this.marker = builder.marker;
    }

    public final boolean hasTaggedResources() {
        return this.taggedResources != null && !(this.taggedResources instanceof SdkAutoConstructList);
    }

    public final List<TaggedResource> taggedResources() {
        return this.taggedResources;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaggedResources() ? this.taggedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return this.hasTaggedResources() == other.hasTaggedResources() && Objects.equals(this.taggedResources(), other.taggedResources()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("TaggedResources", this.hasTaggedResources() ? this.taggedResources() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaggedResources": {
                return Optional.ofNullable(clazz.cast(this.taggedResources()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<TaggedResource> taggedResources = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.taggedResources(model.taggedResources);
            this.marker(model.marker);
        }

        public final List<TaggedResource.Builder> getTaggedResources() {
            List<TaggedResource.Builder> result = TaggedResourceListCopier.copyToBuilder(this.taggedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder taggedResources(Collection<TaggedResource> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copy(taggedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taggedResources(TaggedResource ... taggedResources) {
            this.taggedResources(Arrays.asList(taggedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taggedResources(Consumer<TaggedResource.Builder> ... taggedResources) {
            this.taggedResources(Stream.of(taggedResources).map(c -> (TaggedResource)((TaggedResource.Builder)TaggedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaggedResources(Collection<TaggedResource.BuilderImpl> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copyFromBuilder(taggedResources);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder taggedResources(Collection<TaggedResource> var1);

        public Builder taggedResources(TaggedResource ... var1);

        public Builder taggedResources(Consumer<TaggedResource.Builder> ... var1);

        public Builder marker(String var1);
    }
}

