/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedNodeOfferingsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeReservedNodeOfferingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReservedNodeOfferingsResponse.getter(DescribeReservedNodeOfferingsResponse::marker)).setter(DescribeReservedNodeOfferingsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedNodeOffering>> RESERVED_NODE_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedNodeOfferings").getter(DescribeReservedNodeOfferingsResponse.getter(DescribeReservedNodeOfferingsResponse::reservedNodeOfferings)).setter(DescribeReservedNodeOfferingsResponse.setter(Builder::reservedNodeOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferings").build(), ListTrait.builder().memberLocationName("ReservedNodeOffering").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedNodeOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOffering").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_NODE_OFFERINGS_FIELD));
    private final String marker;
    private final List<ReservedNodeOffering> reservedNodeOfferings;

    private DescribeReservedNodeOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodeOfferings = builder.reservedNodeOfferings;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReservedNodeOfferings() {
        return this.reservedNodeOfferings != null && !(this.reservedNodeOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedNodeOffering> reservedNodeOfferings() {
        return this.reservedNodeOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedNodeOfferings() ? this.reservedNodeOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodeOfferingsResponse)) {
            return false;
        }
        DescribeReservedNodeOfferingsResponse other = (DescribeReservedNodeOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReservedNodeOfferings() == other.hasReservedNodeOfferings() && Objects.equals(this.reservedNodeOfferings(), other.reservedNodeOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedNodeOfferingsResponse").add("Marker", (Object)this.marker()).add("ReservedNodeOfferings", this.hasReservedNodeOfferings() ? this.reservedNodeOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedNodeOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodeOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodeOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNodeOffering> reservedNodeOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodeOfferingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedNodeOfferings(model.reservedNodeOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNodeOffering.Builder> getReservedNodeOfferings() {
            if (this.reservedNodeOfferings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedNodeOfferings != null ? (Collection)this.reservedNodeOfferings.stream().map(ReservedNodeOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedNodeOfferings(Collection<ReservedNodeOffering> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copy(reservedNodeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(ReservedNodeOffering ... reservedNodeOfferings) {
            this.reservedNodeOfferings(Arrays.asList(reservedNodeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder> ... reservedNodeOfferings) {
            this.reservedNodeOfferings(Stream.of(reservedNodeOfferings).map(c -> (ReservedNodeOffering)((ReservedNodeOffering.Builder)ReservedNodeOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedNodeOfferings(Collection<ReservedNodeOffering.BuilderImpl> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copyFromBuilder(reservedNodeOfferings);
        }

        @Override
        public DescribeReservedNodeOfferingsResponse build() {
            return new DescribeReservedNodeOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedNodeOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedNodeOfferings(Collection<ReservedNodeOffering> var1);

        public Builder reservedNodeOfferings(ReservedNodeOffering ... var1);

        public Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder> ... var1);
    }
}

