/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RestoreStatus.getter(RestoreStatus::status)).setter(RestoreStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Double> CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CurrentRestoreRateInMegaBytesPerSecond").getter(RestoreStatus.getter(RestoreStatus::currentRestoreRateInMegaBytesPerSecond)).setter(RestoreStatus.setter(Builder::currentRestoreRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRestoreRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SnapshotSizeInMegaBytes").getter(RestoreStatus.getter(RestoreStatus::snapshotSizeInMegaBytes)).setter(RestoreStatus.setter(Builder::snapshotSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSizeInMegaBytes").build()}).build();
    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProgressInMegaBytes").getter(RestoreStatus.getter(RestoreStatus::progressInMegaBytes)).setter(RestoreStatus.setter(Builder::progressInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeInSeconds").getter(RestoreStatus.getter(RestoreStatus::elapsedTimeInSeconds)).setter(RestoreStatus.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeToCompletionInSeconds").getter(RestoreStatus.getter(RestoreStatus::estimatedTimeToCompletionInSeconds)).setter(RestoreStatus.setter(Builder::estimatedTimeToCompletionInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Double currentRestoreRateInMegaBytesPerSecond;
    private final Long snapshotSizeInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;

    private RestoreStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
    }

    public String status() {
        return this.status;
    }

    public Double currentRestoreRateInMegaBytesPerSecond() {
        return this.currentRestoreRateInMegaBytesPerSecond;
    }

    public Long snapshotSizeInMegaBytes() {
        return this.snapshotSizeInMegaBytes;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRestoreRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreStatus)) {
            return false;
        }
        RestoreStatus other = (RestoreStatus)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.currentRestoreRateInMegaBytesPerSecond(), other.currentRestoreRateInMegaBytesPerSecond()) && Objects.equals(this.snapshotSizeInMegaBytes(), other.snapshotSizeInMegaBytes()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"RestoreStatus").add("Status", (Object)this.status()).add("CurrentRestoreRateInMegaBytesPerSecond", (Object)this.currentRestoreRateInMegaBytesPerSecond()).add("SnapshotSizeInMegaBytes", (Object)this.snapshotSizeInMegaBytes()).add("ProgressInMegaBytes", (Object)this.progressInMegaBytes()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("EstimatedTimeToCompletionInSeconds", (Object)this.estimatedTimeToCompletionInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CurrentRestoreRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.currentRestoreRateInMegaBytesPerSecond()));
            }
            case "SnapshotSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.snapshotSizeInMegaBytes()));
            }
            case "ProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.progressInMegaBytes()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreStatus, T> g) {
        return obj -> g.apply((RestoreStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Double currentRestoreRateInMegaBytesPerSecond;
        private Long snapshotSizeInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreStatus model) {
            this.status(model.status);
            this.currentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            this.snapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return this.currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return this.snapshotSizeInMegaBytes;
        }

        @Override
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public RestoreStatus build() {
            return new RestoreStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreStatus> {
        public Builder status(String var1);

        public Builder currentRestoreRateInMegaBytesPerSecond(Double var1);

        public Builder snapshotSizeInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);
    }
}

