/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AssociatedClusterListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledSnapshotTimeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotSchedule> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleDefinitions").getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleDefinitions)).setter(SnapshotSchedule.setter(Builder::scheduleDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(), ListTrait.builder().memberLocationName("ScheduleDefinition").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinition").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleIdentifier").getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleIdentifier)).setter(SnapshotSchedule.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleDescription").getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleDescription)).setter(SnapshotSchedule.setter(Builder::scheduleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SnapshotSchedule.getter(SnapshotSchedule::tags)).setter(SnapshotSchedule.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NextInvocations").getter(SnapshotSchedule.getter(SnapshotSchedule::nextInvocations)).setter(SnapshotSchedule.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(), ListTrait.builder().memberLocationName("SnapshotTime").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()}).build()).build()}).build();
    private static final SdkField<Integer> ASSOCIATED_CLUSTER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedClusterCount").getter(SnapshotSchedule.getter(SnapshotSchedule::associatedClusterCount)).setter(SnapshotSchedule.setter(Builder::associatedClusterCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusterCount").build()}).build();
    private static final SdkField<List<ClusterAssociatedToSchedule>> ASSOCIATED_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedClusters").getter(SnapshotSchedule.getter(SnapshotSchedule::associatedClusters)).setter(SnapshotSchedule.setter(Builder::associatedClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusters").build(), ListTrait.builder().memberLocationName("ClusterAssociatedToSchedule").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterAssociatedToSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterAssociatedToSchedule").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD, SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, NEXT_INVOCATIONS_FIELD, ASSOCIATED_CLUSTER_COUNT_FIELD, ASSOCIATED_CLUSTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> scheduleDefinitions;
    private final String scheduleIdentifier;
    private final String scheduleDescription;
    private final List<Tag> tags;
    private final List<Instant> nextInvocations;
    private final Integer associatedClusterCount;
    private final List<ClusterAssociatedToSchedule> associatedClusters;

    private SnapshotSchedule(BuilderImpl builder) {
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.nextInvocations = builder.nextInvocations;
        this.associatedClusterCount = builder.associatedClusterCount;
        this.associatedClusters = builder.associatedClusters;
    }

    public boolean hasScheduleDefinitions() {
        return this.scheduleDefinitions != null && !(this.scheduleDefinitions instanceof SdkAutoConstructList);
    }

    public List<String> scheduleDefinitions() {
        return this.scheduleDefinitions;
    }

    public String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public String scheduleDescription() {
        return this.scheduleDescription;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasNextInvocations() {
        return this.nextInvocations != null && !(this.nextInvocations instanceof SdkAutoConstructList);
    }

    public List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public Integer associatedClusterCount() {
        return this.associatedClusterCount;
    }

    public boolean hasAssociatedClusters() {
        return this.associatedClusters != null && !(this.associatedClusters instanceof SdkAutoConstructList);
    }

    public List<ClusterAssociatedToSchedule> associatedClusters() {
        return this.associatedClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedClusterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedClusters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotSchedule)) {
            return false;
        }
        SnapshotSchedule other = (SnapshotSchedule)obj;
        return Objects.equals(this.scheduleDefinitions(), other.scheduleDefinitions()) && Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && Objects.equals(this.scheduleDescription(), other.scheduleDescription()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.nextInvocations(), other.nextInvocations()) && Objects.equals(this.associatedClusterCount(), other.associatedClusterCount()) && Objects.equals(this.associatedClusters(), other.associatedClusters());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotSchedule").add("ScheduleDefinitions", this.scheduleDefinitions()).add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("ScheduleDescription", (Object)this.scheduleDescription()).add("Tags", this.tags()).add("NextInvocations", this.nextInvocations()).add("AssociatedClusterCount", (Object)this.associatedClusterCount()).add("AssociatedClusters", this.associatedClusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleDefinitions": {
                return Optional.ofNullable(clazz.cast(this.scheduleDefinitions()));
            }
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "ScheduleDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduleDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
            case "AssociatedClusterCount": {
                return Optional.ofNullable(clazz.cast(this.associatedClusterCount()));
            }
            case "AssociatedClusters": {
                return Optional.ofNullable(clazz.cast(this.associatedClusters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotSchedule, T> g) {
        return obj -> g.apply((SnapshotSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String scheduleIdentifier;
        private String scheduleDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();
        private Integer associatedClusterCount;
        private List<ClusterAssociatedToSchedule> associatedClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotSchedule model) {
            this.scheduleDefinitions(model.scheduleDefinitions);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.scheduleDescription(model.scheduleDescription);
            this.tags(model.tags);
            this.nextInvocations(model.nextInvocations);
            this.associatedClusterCount(model.associatedClusterCount);
            this.associatedClusters(model.associatedClusters);
        }

        public final Collection<String> getScheduleDefinitions() {
            return this.scheduleDefinitions;
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String ... scheduleDefinitions) {
            this.scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final String getScheduleDescription() {
            return this.scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<Instant> getNextInvocations() {
            return this.nextInvocations;
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
        }

        public final Integer getAssociatedClusterCount() {
            return this.associatedClusterCount;
        }

        @Override
        public final Builder associatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
            return this;
        }

        public final void setAssociatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
        }

        public final Collection<ClusterAssociatedToSchedule.Builder> getAssociatedClusters() {
            return this.associatedClusters != null ? (Collection)this.associatedClusters.stream().map(ClusterAssociatedToSchedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedClusters(Collection<ClusterAssociatedToSchedule> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copy(associatedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(ClusterAssociatedToSchedule ... associatedClusters) {
            this.associatedClusters(Arrays.asList(associatedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder> ... associatedClusters) {
            this.associatedClusters(Stream.of(associatedClusters).map(c -> (ClusterAssociatedToSchedule)((ClusterAssociatedToSchedule.Builder)ClusterAssociatedToSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedClusters(Collection<ClusterAssociatedToSchedule.BuilderImpl> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copyFromBuilder(associatedClusters);
        }

        public SnapshotSchedule build() {
            return new SnapshotSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotSchedule> {
        public Builder scheduleDefinitions(Collection<String> var1);

        public Builder scheduleDefinitions(String ... var1);

        public Builder scheduleIdentifier(String var1);

        public Builder scheduleDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);

        public Builder associatedClusterCount(Integer var1);

        public Builder associatedClusters(Collection<ClusterAssociatedToSchedule> var1);

        public Builder associatedClusters(ClusterAssociatedToSchedule ... var1);

        public Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder> ... var1);
    }
}

