/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AccessToSnapshotDeniedException;
import software.amazon.awssdk.services.redshift.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteRequestSizeExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsLimitExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BucketNotFoundException;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterOnLatestRevisionException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CopyToRegionDisabledException;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DependentServiceRequestThrottlingException;
import software.amazon.awssdk.services.redshift.model.DependentServiceUnavailableException;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.InProgressTableRestoreQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IncompatibleOrderableOptionsException;
import software.amazon.awssdk.services.redshift.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.redshift.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterParameterGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSecurityGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotScheduleStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterTrackException;
import software.amazon.awssdk.services.redshift.model.InvalidElasticIpException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmClientCertificateStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmConfigurationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidReservedNodeStateException;
import software.amazon.awssdk.services.redshift.model.InvalidRestoreException;
import software.amazon.awssdk.services.redshift.model.InvalidRetentionPeriodException;
import software.amazon.awssdk.services.redshift.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.redshift.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduleException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduledActionException;
import software.amazon.awssdk.services.redshift.model.InvalidSnapshotCopyGrantStateException;
import software.amazon.awssdk.services.redshift.model.InvalidSubnetException;
import software.amazon.awssdk.services.redshift.model.InvalidSubscriptionStateException;
import software.amazon.awssdk.services.redshift.model.InvalidTableRestoreArgumentException;
import software.amazon.awssdk.services.redshift.model.InvalidTagException;
import software.amazon.awssdk.services.redshift.model.InvalidUsageLimitException;
import software.amazon.awssdk.services.redshift.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.redshift.model.LimitExceededException;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.PauseClusterRequest;
import software.amazon.awssdk.services.redshift.model.PauseClusterResponse;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyMigratedException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.ResizeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ResumeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResumeClusterResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionNotFoundException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyEnabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleUpdateInProgressException;
import software.amazon.awssdk.services.redshift.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.redshift.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.redshift.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.redshift.model.SourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.redshift.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.redshift.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionEventIdNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionSeverityNotFoundException;
import software.amazon.awssdk.services.redshift.model.TableLimitExceededException;
import software.amazon.awssdk.services.redshift.model.TableRestoreNotFoundException;
import software.amazon.awssdk.services.redshift.model.TagLimitExceededException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.redshift.model.UnknownSnapshotCopyRegionException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOperationException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOptionException;
import software.amazon.awssdk.services.redshift.model.UsageLimitAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.UsageLimitNotFoundException;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher;
import software.amazon.awssdk.services.redshift.transform.AcceptReservedNodeExchangeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchDeleteClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchModifyClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CancelResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CopyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterDbRevisionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterTracksRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterVersionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeLoggingStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeNodeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeOrderableClusterOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotCopyGrantsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotSchedulesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeStorageRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterDbRevisionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterIamRolesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotCopyRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PauseClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PurchaseReservedNodeOfferingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RebootClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResetClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResizeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreTableFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResumeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RotateEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultRedshiftAsyncClient
implements RedshiftAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedshiftAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRedshiftAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "redshift";
    }

    @Override
    public CompletableFuture<AcceptReservedNodeExchangeResponse> acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptReservedNodeExchange");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AcceptReservedNodeExchangeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptReservedNodeExchange").withMarshaller((Marshaller)new AcceptReservedNodeExchangeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)acceptReservedNodeExchangeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = acceptReservedNodeExchangeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, acceptReservedNodeExchangeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeClusterSecurityGroupIngress");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeClusterSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeClusterSecurityGroupIngress").withMarshaller((Marshaller)new AuthorizeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)authorizeClusterSecurityGroupIngressRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = authorizeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, authorizeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AuthorizeSnapshotAccessResponse> authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AuthorizeSnapshotAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeSnapshotAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeSnapshotAccess").withMarshaller((Marshaller)new AuthorizeSnapshotAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)authorizeSnapshotAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = authorizeSnapshotAccessRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, authorizeSnapshotAccessRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteClusterSnapshotsResponse> batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteClusterSnapshots").withMarshaller((Marshaller)new BatchDeleteClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)batchDeleteClusterSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeleteClusterSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteClusterSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchModifyClusterSnapshotsResponse> batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchModifyClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchModifyClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchModifyClusterSnapshots").withMarshaller((Marshaller)new BatchModifyClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)batchModifyClusterSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchModifyClusterSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchModifyClusterSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelResizeResponse> cancelResize(CancelResizeRequest cancelResizeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelResize");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CancelResizeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelResize").withMarshaller((Marshaller)new CancelResizeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)cancelResizeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelResizeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, cancelResizeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyClusterSnapshot").withMarshaller((Marshaller)new CopyClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)copyClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, copyClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterParameterGroupResponse> createClusterParameterGroup(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterParameterGroup").withMarshaller((Marshaller)new CreateClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSecurityGroupResponse> createClusterSecurityGroup(CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSecurityGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSecurityGroup").withMarshaller((Marshaller)new CreateClusterSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createClusterSecurityGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClusterSecurityGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClusterSecurityGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSnapshot").withMarshaller((Marshaller)new CreateClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterSubnetGroupResponse> createClusterSubnetGroup(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSubnetGroup").withMarshaller((Marshaller)new CreateClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createClusterSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClusterSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createEventSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHsmClientCertificateResponse> createHsmClientCertificate(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsmClientCertificate");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmClientCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmClientCertificate").withMarshaller((Marshaller)new CreateHsmClientCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createHsmClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createHsmClientCertificateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createHsmClientCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateHsmConfigurationResponse> createHsmConfiguration(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHsmConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateHsmConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsmConfiguration").withMarshaller((Marshaller)new CreateHsmConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createHsmConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createHsmConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createHsmConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScheduledActionResponse> createScheduledAction(CreateScheduledActionRequest createScheduledActionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledAction").withMarshaller((Marshaller)new CreateScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createScheduledActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createScheduledActionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createScheduledActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotCopyGrantResponse> createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshotCopyGrant");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotCopyGrantResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotCopyGrant").withMarshaller((Marshaller)new CreateSnapshotCopyGrantRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createSnapshotCopyGrantRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSnapshotCopyGrantRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotCopyGrantRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotScheduleResponse> createSnapshotSchedule(CreateSnapshotScheduleRequest createSnapshotScheduleRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotSchedule").withMarshaller((Marshaller)new CreateSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSnapshotScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotScheduleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withMarshaller((Marshaller)new CreateTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUsageLimit").withMarshaller((Marshaller)new CreateUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createUsageLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUsageLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, createUsageLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterParameterGroupResponse> deleteClusterParameterGroup(DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterParameterGroup").withMarshaller((Marshaller)new DeleteClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSecurityGroupResponse> deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSecurityGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSecurityGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSecurityGroup").withMarshaller((Marshaller)new DeleteClusterSecurityGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteClusterSecurityGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClusterSecurityGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterSecurityGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSnapshot").withMarshaller((Marshaller)new DeleteClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClusterSubnetGroupResponse> deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSubnetGroup").withMarshaller((Marshaller)new DeleteClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteClusterSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClusterSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEventSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHsmClientCertificateResponse> deleteHsmClientCertificate(DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsmClientCertificate");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmClientCertificateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmClientCertificate").withMarshaller((Marshaller)new DeleteHsmClientCertificateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteHsmClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteHsmClientCertificateRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteHsmClientCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteHsmConfigurationResponse> deleteHsmConfiguration(DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHsmConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteHsmConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsmConfiguration").withMarshaller((Marshaller)new DeleteHsmConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteHsmConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteHsmConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteHsmConfigurationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteScheduledActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteScheduledActionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteScheduledActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotCopyGrantResponse> deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshotCopyGrant");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotCopyGrantResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotCopyGrant").withMarshaller((Marshaller)new DeleteSnapshotCopyGrantRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotCopyGrantRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSnapshotCopyGrantRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotCopyGrantRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotSchedule").withMarshaller((Marshaller)new DeleteSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSnapshotScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotScheduleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUsageLimit").withMarshaller((Marshaller)new DeleteUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteUsageLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUsageLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteUsageLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountAttributes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountAttributesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeAccountAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeAccountAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeAccountAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions(DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterDbRevisions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterDbRevisionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterDbRevisions").withMarshaller((Marshaller)new DescribeClusterDbRevisionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterDbRevisionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterDbRevisionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterDbRevisionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterParameterGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParameterGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameterGroups").withMarshaller((Marshaller)new DescribeClusterParameterGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterParameterGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterParameterGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterParameterGroupsPublisher describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        return new DescribeClusterParameterGroupsPublisher(this, this.applyPaginatorUserAgent(describeClusterParameterGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterParametersResponse> describeClusterParameters(DescribeClusterParametersRequest describeClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterParameters").withMarshaller((Marshaller)new DescribeClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterParametersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterParametersPublisher describeClusterParametersPaginator(DescribeClusterParametersRequest describeClusterParametersRequest) {
        return new DescribeClusterParametersPublisher(this, this.applyPaginatorUserAgent(describeClusterParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterSecurityGroupsResponse> describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSecurityGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSecurityGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSecurityGroups").withMarshaller((Marshaller)new DescribeClusterSecurityGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterSecurityGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterSecurityGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterSecurityGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterSecurityGroupsPublisher describeClusterSecurityGroupsPaginator(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        return new DescribeClusterSecurityGroupsPublisher(this, this.applyPaginatorUserAgent(describeClusterSecurityGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSnapshots");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSnapshotsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSnapshots").withMarshaller((Marshaller)new DescribeClusterSnapshotsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterSnapshotsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterSnapshotsPublisher describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        return new DescribeClusterSnapshotsPublisher(this, this.applyPaginatorUserAgent(describeClusterSnapshotsRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterSubnetGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterSubnetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterSubnetGroups").withMarshaller((Marshaller)new DescribeClusterSubnetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterSubnetGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterSubnetGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterSubnetGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterSubnetGroupsPublisher describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        return new DescribeClusterSubnetGroupsPublisher(this, this.applyPaginatorUserAgent(describeClusterSubnetGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks(DescribeClusterTracksRequest describeClusterTracksRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterTracks");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterTracksResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterTracks").withMarshaller((Marshaller)new DescribeClusterTracksRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterTracksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterTracksRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterTracksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions(DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusterVersions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClusterVersionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusterVersions").withMarshaller((Marshaller)new DescribeClusterVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClusterVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClusterVersionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClusterVersionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClusterVersionsPublisher describeClusterVersionsPaginator(DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        return new DescribeClusterVersionsPublisher(this, this.applyPaginatorUserAgent(describeClusterVersionsRequest));
    }

    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeClusters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeClustersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeClusters").withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeClustersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeClustersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeClustersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeClustersPublisher describeClustersPaginator(DescribeClustersRequest describeClustersRequest) {
        return new DescribeClustersPublisher(this, this.applyPaginatorUserAgent(describeClustersRequest));
    }

    @Override
    public CompletableFuture<DescribeDefaultClusterParametersResponse> describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDefaultClusterParameters");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDefaultClusterParametersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDefaultClusterParameters").withMarshaller((Marshaller)new DescribeDefaultClusterParametersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeDefaultClusterParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDefaultClusterParametersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDefaultClusterParametersPublisher describeDefaultClusterParametersPaginator(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        return new DescribeDefaultClusterParametersPublisher(this, this.applyPaginatorUserAgent(describeDefaultClusterParametersRequest));
    }

    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventCategoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventCategoriesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventSubscriptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventSubscriptionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHsmClientCertificates");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmClientCertificatesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmClientCertificates").withMarshaller((Marshaller)new DescribeHsmClientCertificatesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeHsmClientCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeHsmClientCertificatesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeHsmClientCertificatesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeHsmClientCertificatesPublisher describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        return new DescribeHsmClientCertificatesPublisher(this, this.applyPaginatorUserAgent(describeHsmClientCertificatesRequest));
    }

    @Override
    public CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHsmConfigurations");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeHsmConfigurationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsmConfigurations").withMarshaller((Marshaller)new DescribeHsmConfigurationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeHsmConfigurationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeHsmConfigurationsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeHsmConfigurationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeHsmConfigurationsPublisher describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        return new DescribeHsmConfigurationsPublisher(this, this.applyPaginatorUserAgent(describeHsmConfigurationsRequest));
    }

    @Override
    public CompletableFuture<DescribeLoggingStatusResponse> describeLoggingStatus(DescribeLoggingStatusRequest describeLoggingStatusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoggingStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoggingStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingStatus").withMarshaller((Marshaller)new DescribeLoggingStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeLoggingStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeLoggingStatusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLoggingStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNodeConfigurationOptionsResponse> describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNodeConfigurationOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNodeConfigurationOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeConfigurationOptions").withMarshaller((Marshaller)new DescribeNodeConfigurationOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeNodeConfigurationOptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeNodeConfigurationOptionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeNodeConfigurationOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeNodeConfigurationOptionsPublisher describeNodeConfigurationOptionsPaginator(DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        return new DescribeNodeConfigurationOptionsPublisher(this, this.applyPaginatorUserAgent(describeNodeConfigurationOptionsRequest));
    }

    @Override
    public CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableClusterOptions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableClusterOptionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableClusterOptions").withMarshaller((Marshaller)new DescribeOrderableClusterOptionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeOrderableClusterOptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeOrderableClusterOptionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableClusterOptionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeOrderableClusterOptionsPublisher describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        return new DescribeOrderableClusterOptionsPublisher(this, this.applyPaginatorUserAgent(describeOrderableClusterOptionsRequest));
    }

    @Override
    public CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodeOfferings");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodeOfferingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodeOfferings").withMarshaller((Marshaller)new DescribeReservedNodeOfferingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeReservedNodeOfferingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeReservedNodeOfferingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeReservedNodeOfferingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeReservedNodeOfferingsPublisher describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        return new DescribeReservedNodeOfferingsPublisher(this, this.applyPaginatorUserAgent(describeReservedNodeOfferingsRequest));
    }

    @Override
    public CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservedNodes");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedNodesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedNodes").withMarshaller((Marshaller)new DescribeReservedNodesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeReservedNodesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeReservedNodesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeReservedNodesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeReservedNodesPublisher describeReservedNodesPaginator(DescribeReservedNodesRequest describeReservedNodesRequest) {
        return new DescribeReservedNodesPublisher(this, this.applyPaginatorUserAgent(describeReservedNodesRequest));
    }

    @Override
    public CompletableFuture<DescribeResizeResponse> describeResize(DescribeResizeRequest describeResizeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResize");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeResizeResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResize").withMarshaller((Marshaller)new DescribeResizeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeResizeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeResizeRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeResizeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeScheduledActionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeScheduledActionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeScheduledActionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeScheduledActionsPublisher describeScheduledActionsPaginator(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        return new DescribeScheduledActionsPublisher(this, this.applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    @Override
    public CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshotCopyGrants");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotCopyGrantsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotCopyGrants").withMarshaller((Marshaller)new DescribeSnapshotCopyGrantsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeSnapshotCopyGrantsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSnapshotCopyGrantsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSnapshotCopyGrantsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules(DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshotSchedules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotSchedulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotSchedules").withMarshaller((Marshaller)new DescribeSnapshotSchedulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeSnapshotSchedulesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSnapshotSchedulesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeSnapshotSchedulesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStorageResponse> describeStorage(DescribeStorageRequest describeStorageRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorage");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeStorageResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorage").withMarshaller((Marshaller)new DescribeStorageRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeStorageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStorageRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeStorageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableRestoreStatusResponse> describeTableRestoreStatus(DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableRestoreStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTableRestoreStatusResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableRestoreStatus").withMarshaller((Marshaller)new DescribeTableRestoreStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeTableRestoreStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTableRestoreStatusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTableRestoreStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUsageLimitsResponse> describeUsageLimits(DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsageLimits");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeUsageLimitsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsageLimits").withMarshaller((Marshaller)new DescribeUsageLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeUsageLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeUsageLimitsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeUsageLimitsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeUsageLimitsPublisher describeUsageLimitsPaginator(DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        return new DescribeUsageLimitsPublisher(this, this.applyPaginatorUserAgent(describeUsageLimitsRequest));
    }

    @Override
    public CompletableFuture<DisableLoggingResponse> disableLogging(DisableLoggingRequest disableLoggingRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableLogging");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableLoggingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableLogging").withMarshaller((Marshaller)new DisableLoggingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disableLoggingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableLoggingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableLoggingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableSnapshotCopyResponse> disableSnapshotCopy(DisableSnapshotCopyRequest disableSnapshotCopyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableSnapshotCopy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableSnapshotCopyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSnapshotCopy").withMarshaller((Marshaller)new DisableSnapshotCopyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disableSnapshotCopyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableSnapshotCopyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableSnapshotCopyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableLoggingResponse> enableLogging(EnableLoggingRequest enableLoggingRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableLogging");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableLoggingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableLogging").withMarshaller((Marshaller)new EnableLoggingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)enableLoggingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableLoggingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableLoggingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableSnapshotCopyResponse> enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSnapshotCopy");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableSnapshotCopyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSnapshotCopy").withMarshaller((Marshaller)new EnableSnapshotCopyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)enableSnapshotCopyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableSnapshotCopyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableSnapshotCopyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetClusterCredentialsResponse> getClusterCredentials(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClusterCredentials");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetClusterCredentialsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClusterCredentials").withMarshaller((Marshaller)new GetClusterCredentialsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getClusterCredentialsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getClusterCredentialsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, getClusterCredentialsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservedNodeExchangeOfferingsResponse> getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservedNodeExchangeOfferings");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetReservedNodeExchangeOfferingsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservedNodeExchangeOfferings").withMarshaller((Marshaller)new GetReservedNodeExchangeOfferingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getReservedNodeExchangeOfferingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getReservedNodeExchangeOfferingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, getReservedNodeExchangeOfferingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCluster").withMarshaller((Marshaller)new ModifyClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterDbRevisionResponse> modifyClusterDbRevision(ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterDbRevision");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterDbRevisionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterDbRevision").withMarshaller((Marshaller)new ModifyClusterDbRevisionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterDbRevisionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterDbRevisionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterDbRevisionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterIamRolesResponse> modifyClusterIamRoles(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterIamRoles");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterIamRolesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterIamRoles").withMarshaller((Marshaller)new ModifyClusterIamRolesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterIamRolesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterIamRolesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterIamRolesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterMaintenanceResponse> modifyClusterMaintenance(ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterMaintenance");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterMaintenanceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterMaintenance").withMarshaller((Marshaller)new ModifyClusterMaintenanceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterMaintenanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterMaintenanceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterMaintenanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterParameterGroupResponse> modifyClusterParameterGroup(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterParameterGroup").withMarshaller((Marshaller)new ModifyClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSnapshotResponse> modifyClusterSnapshot(ModifyClusterSnapshotRequest modifyClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshot").withMarshaller((Marshaller)new ModifyClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSnapshotScheduleResponse> modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSnapshotSchedule").withMarshaller((Marshaller)new ModifyClusterSnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterSnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterSnapshotScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterSnapshotScheduleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyClusterSubnetGroupResponse> modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyClusterSubnetGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyClusterSubnetGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyClusterSubnetGroup").withMarshaller((Marshaller)new ModifyClusterSubnetGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyClusterSubnetGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyClusterSubnetGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyClusterSubnetGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyEventSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyEventSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyScheduledActionResponse> modifyScheduledAction(ModifyScheduledActionRequest modifyScheduledActionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyScheduledAction");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyScheduledAction").withMarshaller((Marshaller)new ModifyScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyScheduledActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyScheduledActionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyScheduledActionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifySnapshotCopyRetentionPeriodResponse> modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySnapshotCopyRetentionPeriod");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotCopyRetentionPeriodResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotCopyRetentionPeriod").withMarshaller((Marshaller)new ModifySnapshotCopyRetentionPeriodRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifySnapshotCopyRetentionPeriodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifySnapshotCopyRetentionPeriodRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifySnapshotCopyRetentionPeriodRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifySnapshotScheduleResponse> modifySnapshotSchedule(ModifySnapshotScheduleRequest modifySnapshotScheduleRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifySnapshotSchedule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifySnapshotScheduleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifySnapshotSchedule").withMarshaller((Marshaller)new ModifySnapshotScheduleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifySnapshotScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifySnapshotScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifySnapshotScheduleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ModifyUsageLimitResponse> modifyUsageLimit(ModifyUsageLimitRequest modifyUsageLimitRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyUsageLimit");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyUsageLimitResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyUsageLimit").withMarshaller((Marshaller)new ModifyUsageLimitRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)modifyUsageLimitRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = modifyUsageLimitRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, modifyUsageLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PauseClusterResponse> pauseCluster(PauseClusterRequest pauseClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PauseCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PauseClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PauseCluster").withMarshaller((Marshaller)new PauseClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)pauseClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = pauseClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, pauseClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurchaseReservedNodeOfferingResponse> purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseReservedNodeOffering");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurchaseReservedNodeOfferingResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedNodeOffering").withMarshaller((Marshaller)new PurchaseReservedNodeOfferingRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)purchaseReservedNodeOfferingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = purchaseReservedNodeOfferingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, purchaseReservedNodeOfferingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootClusterResponse> rebootCluster(RebootClusterRequest rebootClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootCluster").withMarshaller((Marshaller)new RebootClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)rebootClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rebootClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, rebootClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetClusterParameterGroupResponse> resetClusterParameterGroup(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetClusterParameterGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetClusterParameterGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetClusterParameterGroup").withMarshaller((Marshaller)new ResetClusterParameterGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resetClusterParameterGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetClusterParameterGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetClusterParameterGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResizeClusterResponse> resizeCluster(ResizeClusterRequest resizeClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResizeCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResizeClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResizeCluster").withMarshaller((Marshaller)new ResizeClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resizeClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resizeClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, resizeClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreFromClusterSnapshotResponse> restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreFromClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromClusterSnapshot").withMarshaller((Marshaller)new RestoreFromClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreFromClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreFromClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreFromClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreTableFromClusterSnapshotResponse> restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromClusterSnapshot");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreTableFromClusterSnapshotResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromClusterSnapshot").withMarshaller((Marshaller)new RestoreTableFromClusterSnapshotRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)restoreTableFromClusterSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = restoreTableFromClusterSnapshotRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreTableFromClusterSnapshotRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResumeClusterResponse> resumeCluster(ResumeClusterRequest resumeClusterRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeCluster");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeClusterResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeCluster").withMarshaller((Marshaller)new ResumeClusterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resumeClusterRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resumeClusterRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, resumeClusterRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeClusterSecurityGroupIngressResponse> revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeClusterSecurityGroupIngress");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeClusterSecurityGroupIngressResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeClusterSecurityGroupIngress").withMarshaller((Marshaller)new RevokeClusterSecurityGroupIngressRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)revokeClusterSecurityGroupIngressRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = revokeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, revokeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeSnapshotAccessResponse> revokeSnapshotAccess(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeSnapshotAccess");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeSnapshotAccessResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeSnapshotAccess").withMarshaller((Marshaller)new RevokeSnapshotAccessRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)revokeSnapshotAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = revokeSnapshotAccessRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, revokeSnapshotAccessRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RotateEncryptionKeyResponse> rotateEncryptionKey(RotateEncryptionKeyRequest rotateEncryptionKeyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RotateEncryptionKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RotateEncryptionKeyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RotateEncryptionKey").withMarshaller((Marshaller)new RotateEncryptionKeyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)rotateEncryptionKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rotateEncryptionKeyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultRedshiftAsyncClient.resolveMetricPublishers(this.clientConfiguration, rotateEncryptionKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmConfigurationStateFault").exceptionBuilderSupplier(InvalidHsmConfigurationStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleAlreadyExists").exceptionBuilderSupplier(SnapshotScheduleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleQuotaExceeded").exceptionBuilderSupplier(SnapshotScheduleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionNotFound").exceptionBuilderSupplier(ScheduledActionNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionEventIdNotFound").exceptionBuilderSupplier(SubscriptionEventIdNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubscriptionStateFault").exceptionBuilderSupplier(InvalidSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotScheduleState").exceptionBuilderSupplier(InvalidClusterSnapshotScheduleStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidUsageLimit").exceptionBuilderSupplier(InvalidUsageLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterTrack").exceptionBuilderSupplier(InvalidClusterTrackException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionSeverityNotFound").exceptionBuilderSupplier(SubscriptionSeverityNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CopyToRegionDisabledFault").exceptionBuilderSupplier(CopyToRegionDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestore").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(406)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyDisabledFault").exceptionBuilderSupplier(SnapshotCopyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupQuotaExceeded").exceptionBuilderSupplier(ClusterSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSchedule").exceptionBuilderSupplier(InvalidScheduleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceRequestThrottlingFault").exceptionBuilderSupplier(DependentServiceRequestThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketNotFoundFault").exceptionBuilderSupplier(BucketNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededFault").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionQuotaExceeded").exceptionBuilderSupplier(ScheduledActionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTableRestoreArgument").exceptionBuilderSupplier(InvalidTableRestoreArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantAlreadyExistsFault").exceptionBuilderSupplier(SnapshotCopyGrantAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantQuotaExceededFault").exceptionBuilderSupplier(SnapshotCopyGrantQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownSnapshotCopyRegionFault").exceptionBuilderSupplier(UnknownSnapshotCopyRegionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableRestoreNotFoundFault").exceptionBuilderSupplier(TableRestoreNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterNotFound").exceptionBuilderSupplier(ClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterQuotaExceeded").exceptionBuilderSupplier(ClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationQuotaExceededFault").exceptionBuilderSupplier(HsmConfigurationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyGrantNotFoundFault").exceptionBuilderSupplier(SnapshotCopyGrantNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyMigrated").exceptionBuilderSupplier(ReservedNodeAlreadyMigratedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateNotFoundFault").exceptionBuilderSupplier(HsmClientCertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyEnabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationAlreadyExistsFault").exceptionBuilderSupplier(HsmConfigurationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionAlreadyExists").exceptionBuilderSupplier(ScheduledActionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterState").exceptionBuilderSupplier(InvalidClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReservedNodeState").exceptionBuilderSupplier(InvalidReservedNodeStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetQuotaExceededFault").exceptionBuilderSupplier(ClusterSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterParameterGroupState").exceptionBuilderSupplier(InvalidClusterParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceUnavailableFault").exceptionBuilderSupplier(DependentServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupNotFoundFault").exceptionBuilderSupplier(ClusterSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyDisabledFault").exceptionBuilderSupplier(SnapshotCopyAlreadyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupNotFound").exceptionBuilderSupplier(ClusterSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotQuotaExceeded").exceptionBuilderSupplier(ClusterSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterAlreadyExists").exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmConfigurationNotFoundFault").exceptionBuilderSupplier(HsmConfigurationNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesPerClusterLimitExceeded").exceptionBuilderSupplier(NumberOfNodesPerClusterLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfNodesQuotaExceeded").exceptionBuilderSupplier(NumberOfNodesQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotAlreadyExists").exceptionBuilderSupplier(ClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRetentionPeriodFault").exceptionBuilderSupplier(InvalidRetentionPeriodException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSecurityGroupAlreadyExists").exceptionBuilderSupplier(ClusterSecurityGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded").exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeOfferingNotFound").exceptionBuilderSupplier(ReservedNodeOfferingNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UsageLimitNotFound").exceptionBuilderSupplier(UsageLimitNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InProgressTableRestoreQuotaExceededFault").exceptionBuilderSupplier(InProgressTableRestoreQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessToSnapshotDenied").exceptionBuilderSupplier(AccessToSnapshotDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidElasticIpFault").exceptionBuilderSupplier(InvalidElasticIpException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableLimitExceeded").exceptionBuilderSupplier(TableLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleUpdateInProgress").exceptionBuilderSupplier(SnapshotScheduleUpdateInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnapshotCopyGrantStateFault").exceptionBuilderSupplier(InvalidSnapshotCopyGrantStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResizeNotFound").exceptionBuilderSupplier(ResizeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHsmClientCertificateStateFault").exceptionBuilderSupplier(InvalidHsmClientCertificateStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetGroupStateFault").exceptionBuilderSupplier(InvalidClusterSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterOnLatestRevision").exceptionBuilderSupplier(ClusterOnLatestRevisionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSnapshotNotFound").exceptionBuilderSupplier(ClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduleDefinitionTypeUnsupported").exceptionBuilderSupplier(ScheduleDefinitionTypeUnsupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchModifyClusterSnapshotsLimitExceededFault").exceptionBuilderSupplier(BatchModifyClusterSnapshotsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagFault").exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateAlreadyExistsFault").exceptionBuilderSupplier(HsmClientCertificateAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HsmClientCertificateQuotaExceededFault").exceptionBuilderSupplier(HsmClientCertificateQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSecurityGroupState").exceptionBuilderSupplier(InvalidClusterSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceeded").exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScheduledActionTypeUnsupported").exceptionBuilderSupplier(ScheduledActionTypeUnsupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupQuotaExceeded").exceptionBuilderSupplier(ClusterParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperation").exceptionBuilderSupplier(UnauthorizedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSubnetStateFault").exceptionBuilderSupplier(InvalidClusterSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotScheduleNotFound").exceptionBuilderSupplier(SnapshotScheduleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExists").exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNodeNotFound").exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheduledAction").exceptionBuilderSupplier(InvalidScheduledActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleOrderableOptions").exceptionBuilderSupplier(IncompatibleOrderableOptionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameFault").exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOptionFault").exceptionBuilderSupplier(UnsupportedOptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UsageLimitAlreadyExists").exceptionBuilderSupplier(UsageLimitAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientClusterCapacity").exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterSubnetGroupAlreadyExists").exceptionBuilderSupplier(ClusterSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededFault").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupNotFound").exceptionBuilderSupplier(ClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceeded.ClusterSecurityGroup").exceptionBuilderSupplier(ClusterSecurityGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists").exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotState").exceptionBuilderSupplier(InvalidClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterParameterGroupAlreadyExists").exceptionBuilderSupplier(ClusterParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyFault").exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchDeleteRequestSizeExceeded").exceptionBuilderSupplier(BatchDeleteRequestSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixFault").exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RedshiftException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends RedshiftRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.60").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RedshiftRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

