/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;

public class DescribeReservedNodesRequestMarshaller
implements Marshaller<Request<DescribeReservedNodesRequest>, DescribeReservedNodesRequest> {
    public Request<DescribeReservedNodesRequest> marshall(DescribeReservedNodesRequest describeReservedNodesRequest) {
        if (describeReservedNodesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedNodesRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeReservedNodes");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedNodesRequest.reservedNodeId() != null) {
            request.addParameter("ReservedNodeId", StringUtils.fromString((String)describeReservedNodesRequest.reservedNodeId()));
        }
        if (describeReservedNodesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedNodesRequest.maxRecords()));
        }
        if (describeReservedNodesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedNodesRequest.marker()));
        }
        return request;
    }
}

