/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;

public class DescribeOrderableClusterOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableClusterOptionsRequest>, DescribeOrderableClusterOptionsRequest> {
    public Request<DescribeOrderableClusterOptionsRequest> marshall(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        if (describeOrderableClusterOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeOrderableClusterOptionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeOrderableClusterOptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableClusterOptionsRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.clusterVersion()));
        }
        if (describeOrderableClusterOptionsRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.nodeType()));
        }
        if (describeOrderableClusterOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOrderableClusterOptionsRequest.maxRecords()));
        }
        if (describeOrderableClusterOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.marker()));
        }
        return request;
    }
}

