/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;

public class DeleteClusterSnapshotRequestMarshaller
implements Marshaller<Request<DeleteClusterSnapshotRequest>, DeleteClusterSnapshotRequest> {
    public Request<DeleteClusterSnapshotRequest> marshall(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        if (deleteClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)deleteClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (deleteClusterSnapshotRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)deleteClusterSnapshotRequest.snapshotClusterIdentifier()));
        }
        return request;
    }
}

