/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;

public class DescribeOrderableClusterOptionsIterable
implements SdkIterable<DescribeOrderableClusterOptionsResponse> {
    private final RedshiftClient client;
    private final DescribeOrderableClusterOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrderableClusterOptionsIterable(RedshiftClient client, DescribeOrderableClusterOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrderableClusterOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableClusterOptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<OrderableClusterOption> orderableClusterOptions() {
        Function<DescribeOrderableClusterOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableClusterOptions() != null) {
                return response.orderableClusterOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeOrderableClusterOptionsIterable resume(DescribeOrderableClusterOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableClusterOptionsIterable(this.client, (DescribeOrderableClusterOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableClusterOptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeOrderableClusterOptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeOrderableClusterOptionsResponseFetcher
    implements SyncPageFetcher<DescribeOrderableClusterOptionsResponse> {
        private DescribeOrderableClusterOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOrderableClusterOptionsResponse nextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableClusterOptionsIterable.this.client.describeOrderableClusterOptions(DescribeOrderableClusterOptionsIterable.this.firstRequest);
            }
            return DescribeOrderableClusterOptionsIterable.this.client.describeOrderableClusterOptions((DescribeOrderableClusterOptionsRequest)((Object)DescribeOrderableClusterOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

