/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;

public class DescribeClusterSubnetGroupsIterable
implements SdkIterable<DescribeClusterSubnetGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterSubnetGroupsIterable(RedshiftClient client, DescribeClusterSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterSubnetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ClusterSubnetGroup> clusterSubnetGroups() {
        Function<DescribeClusterSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSubnetGroups() != null) {
                return response.clusterSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeClusterSubnetGroupsIterable resume(DescribeClusterSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSubnetGroupsIterable(this.client, (DescribeClusterSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSubnetGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterSubnetGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeClusterSubnetGroupsResponse> {
        private DescribeClusterSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterSubnetGroupsResponse nextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSubnetGroupsIterable.this.client.describeClusterSubnetGroups(DescribeClusterSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeClusterSubnetGroupsIterable.this.client.describeClusterSubnetGroups((DescribeClusterSubnetGroupsRequest)((Object)DescribeClusterSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

