/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseReservedNodeOfferingRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, PurchaseReservedNodeOfferingRequest> {
    private final String reservedNodeOfferingId;
    private final Integer nodeCount;

    private PurchaseReservedNodeOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeCount = builder.nodeCount;
    }

    public String reservedNodeOfferingId() {
        return this.reservedNodeOfferingId;
    }

    public Integer nodeCount() {
        return this.nodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedNodeOfferingRequest)) {
            return false;
        }
        PurchaseReservedNodeOfferingRequest other = (PurchaseReservedNodeOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedNodeOfferingId(), other.reservedNodeOfferingId()) && Objects.equals(this.nodeCount(), other.nodeCount());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseReservedNodeOfferingRequest").add("ReservedNodeOfferingId", (Object)this.reservedNodeOfferingId()).add("NodeCount", (Object)this.nodeCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeOfferingId": {
                return Optional.of(clazz.cast(this.reservedNodeOfferingId()));
            }
            case "NodeCount": {
                return Optional.of(clazz.cast(this.nodeCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String reservedNodeOfferingId;
        private Integer nodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedNodeOfferingRequest model) {
            this.reservedNodeOfferingId(model.reservedNodeOfferingId);
            this.nodeCount(model.nodeCount);
        }

        public final String getReservedNodeOfferingId() {
            return this.reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedNodeOfferingRequest build() {
            return new PurchaseReservedNodeOfferingRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, PurchaseReservedNodeOfferingRequest> {
        public Builder reservedNodeOfferingId(String var1);

        public Builder nodeCount(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

