/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOptionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOrderableClusterOptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
    private final List<OrderableClusterOption> orderableClusterOptions;
    private final String marker;

    private DescribeOrderableClusterOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableClusterOptions = builder.orderableClusterOptions;
        this.marker = builder.marker;
    }

    public List<OrderableClusterOption> orderableClusterOptions() {
        return this.orderableClusterOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderableClusterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsResponse)) {
            return false;
        }
        DescribeOrderableClusterOptionsResponse other = (DescribeOrderableClusterOptionsResponse)((Object)obj);
        return Objects.equals(this.orderableClusterOptions(), other.orderableClusterOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrderableClusterOptionsResponse").add("OrderableClusterOptions", this.orderableClusterOptions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableClusterOptions": {
                return Optional.of(clazz.cast(this.orderableClusterOptions()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<OrderableClusterOption> orderableClusterOptions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsResponse model) {
            this.orderableClusterOptions(model.orderableClusterOptions);
            this.marker(model.marker);
        }

        public final Collection<OrderableClusterOption.Builder> getOrderableClusterOptions() {
            return this.orderableClusterOptions != null ? (Collection)this.orderableClusterOptions.stream().map(OrderableClusterOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(OrderableClusterOption ... orderableClusterOptions) {
            this.orderableClusterOptions(Arrays.asList(orderableClusterOptions));
            return this;
        }

        public final void setOrderableClusterOptions(Collection<OrderableClusterOption.BuilderImpl> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copyFromBuilder(orderableClusterOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableClusterOptionsResponse build() {
            return new DescribeOrderableClusterOptionsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
        public Builder orderableClusterOptions(Collection<OrderableClusterOption> var1);

        public Builder orderableClusterOptions(OrderableClusterOption ... var1);

        public Builder marker(String var1);
    }
}

