/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateSnapshotCopyGrantRequestMarshaller
implements Marshaller<Request<CreateSnapshotCopyGrantRequest>, CreateSnapshotCopyGrantRequest> {
    public Request<CreateSnapshotCopyGrantRequest> marshall(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        List<Tag> tagsList;
        if (createSnapshotCopyGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createSnapshotCopyGrantRequest, "RedshiftClient");
        request.addParameter("Action", "CreateSnapshotCopyGrant");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotCopyGrantRequest.snapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString((String)createSnapshotCopyGrantRequest.snapshotCopyGrantName()));
        }
        if (createSnapshotCopyGrantRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createSnapshotCopyGrantRequest.kmsKeyId()));
        }
        if ((tagsList = createSnapshotCopyGrantRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

