/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        List<String> list;
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        List<String> clusterSecurityGroupsList;
        if (createClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterRequest, "RedshiftClient");
        request.addParameter("Action", "CreateCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterRequest.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)createClusterRequest.dbName()));
        }
        if (createClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)createClusterRequest.clusterIdentifier()));
        }
        if (createClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)createClusterRequest.clusterType()));
        }
        if (createClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)createClusterRequest.nodeType()));
        }
        if (createClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createClusterRequest.masterUsername()));
        }
        if (createClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createClusterRequest.masterUserPassword()));
        }
        if ((clusterSecurityGroupsList = createClusterRequest.clusterSecurityGroups()) != null) {
            if (!clusterSecurityGroupsList.isEmpty()) {
                int clusterSecurityGroupsListIndex = 1;
                for (String string : clusterSecurityGroupsList) {
                    if (string != null) {
                        request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)string));
                    }
                    ++clusterSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("ClusterSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = createClusterRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String string : vpcSecurityGroupIdsList) {
                    if (string != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)string));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (createClusterRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)createClusterRequest.clusterSubnetGroupName()));
        }
        if (createClusterRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createClusterRequest.availabilityZone()));
        }
        if (createClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createClusterRequest.preferredMaintenanceWindow()));
        }
        if (createClusterRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)createClusterRequest.clusterParameterGroupName()));
        }
        if (createClusterRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)createClusterRequest.automatedSnapshotRetentionPeriod()));
        }
        if (createClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createClusterRequest.port()));
        }
        if (createClusterRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)createClusterRequest.clusterVersion()));
        }
        if (createClusterRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)createClusterRequest.allowVersionUpgrade()));
        }
        if (createClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)createClusterRequest.numberOfNodes()));
        }
        if (createClusterRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createClusterRequest.publiclyAccessible()));
        }
        if (createClusterRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createClusterRequest.encrypted()));
        }
        if (createClusterRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)createClusterRequest.hsmClientCertificateIdentifier()));
        }
        if (createClusterRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createClusterRequest.hsmConfigurationIdentifier()));
        }
        if (createClusterRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)createClusterRequest.elasticIp()));
        }
        if ((tagsList = createClusterRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createClusterRequest.kmsKeyId()));
        }
        if (createClusterRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)createClusterRequest.enhancedVpcRouting()));
        }
        if (createClusterRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)createClusterRequest.additionalInfo()));
        }
        if ((list = createClusterRequest.iamRoles()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (String iamRolesListValue : list) {
                    void var7_18;
                    if (iamRolesListValue != null) {
                        request.addParameter("IamRoles.IamRoleArn." + (int)var7_18, StringUtils.fromString((String)iamRolesListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("IamRoles", "");
            }
        }
        return request;
    }
}

