/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public final class DescribeReservedNodeOfferingsPaginator
implements SdkIterable<DescribeReservedNodeOfferingsResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodeOfferingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedNodeOfferingsPaginator(RedshiftClient client, DescribeReservedNodeOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodeOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedNodeOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedNodeOffering> reservedNodeOfferings() {
        Function<DescribeReservedNodeOfferingsResponse, Iterator> getIterator = response -> response != null ? response.reservedNodeOfferings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedNodeOfferingsResponseFetcher
    implements NextPageFetcher<DescribeReservedNodeOfferingsResponse> {
        private DescribeReservedNodeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedNodeOfferingsResponse nextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeOfferingsPaginator.this.client.describeReservedNodeOfferings(DescribeReservedNodeOfferingsPaginator.this.firstRequest);
            }
            return DescribeReservedNodeOfferingsPaginator.this.client.describeReservedNodeOfferings((DescribeReservedNodeOfferingsRequest)((Object)DescribeReservedNodeOfferingsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

