/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;

public final class DescribeHsmConfigurationsPaginator
implements SdkIterable<DescribeHsmConfigurationsResponse> {
    private final RedshiftClient client;
    private final DescribeHsmConfigurationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeHsmConfigurationsPaginator(RedshiftClient client, DescribeHsmConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHsmConfigurationsResponseFetcher();
    }

    public Iterator<DescribeHsmConfigurationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<HsmConfiguration> hsmConfigurations() {
        Function<DescribeHsmConfigurationsResponse, Iterator> getIterator = response -> response != null ? response.hsmConfigurations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeHsmConfigurationsResponseFetcher
    implements NextPageFetcher<DescribeHsmConfigurationsResponse> {
        private DescribeHsmConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmConfigurationsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeHsmConfigurationsResponse nextPage(DescribeHsmConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmConfigurationsPaginator.this.client.describeHsmConfigurations(DescribeHsmConfigurationsPaginator.this.firstRequest);
            }
            return DescribeHsmConfigurationsPaginator.this.client.describeHsmConfigurations((DescribeHsmConfigurationsRequest)((Object)DescribeHsmConfigurationsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

