/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;

public final class DescribeClusterSecurityGroupsPaginator
implements SdkIterable<DescribeClusterSecurityGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSecurityGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterSecurityGroupsPaginator(RedshiftClient client, DescribeClusterSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterSecurityGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ClusterSecurityGroup> clusterSecurityGroups() {
        Function<DescribeClusterSecurityGroupsResponse, Iterator> getIterator = response -> response != null ? response.clusterSecurityGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterSecurityGroupsResponseFetcher
    implements NextPageFetcher<DescribeClusterSecurityGroupsResponse> {
        private DescribeClusterSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterSecurityGroupsResponse nextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSecurityGroupsPaginator.this.client.describeClusterSecurityGroups(DescribeClusterSecurityGroupsPaginator.this.firstRequest);
            }
            return DescribeClusterSecurityGroupsPaginator.this.client.describeClusterSecurityGroups((DescribeClusterSecurityGroupsRequest)((Object)DescribeClusterSecurityGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

