/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventInfoMap
implements ToCopyableBuilder<Builder, EventInfoMap> {
    private final String eventId;
    private final List<String> eventCategories;
    private final String eventDescription;
    private final String severity;

    private EventInfoMap(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventCategories = builder.eventCategories;
        this.eventDescription = builder.eventDescription;
        this.severity = builder.severity;
    }

    public String eventId() {
        return this.eventId;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String eventDescription() {
        return this.eventDescription;
    }

    public String severity() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.eventDescription(), other.eventDescription()) && Objects.equals(this.severity(), other.severity());
    }

    public String toString() {
        return ToString.builder((String)"EventInfoMap").add("EventId", (Object)this.eventId()).add("EventCategories", this.eventCategories()).add("EventDescription", (Object)this.eventDescription()).add("Severity", (Object)this.severity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
            case "EventCategories": {
                return Optional.of(clazz.cast(this.eventCategories()));
            }
            case "EventDescription": {
                return Optional.of(clazz.cast(this.eventDescription()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private List<String> eventCategories;
        private String eventDescription;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInfoMap model) {
            this.eventId(model.eventId);
            this.eventCategories(model.eventCategories);
            this.eventDescription(model.eventDescription);
            this.severity(model.severity);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getEventDescription() {
            return this.eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public EventInfoMap build() {
            return new EventInfoMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventInfoMap> {
        public Builder eventId(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder eventDescription(String var1);

        public Builder severity(String var1);
    }
}

