/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Endpoint
implements ToCopyableBuilder<Builder, Endpoint> {
    private final String address;
    private final Integer port;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.port = builder.port;
    }

    public String address() {
        return this.address;
    }

    public Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.port(), other.port());
    }

    public String toString() {
        return ToString.builder((String)"Endpoint").add("Address", (Object)this.address()).add("Port", (Object)this.port()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.address(model.address);
            this.port(model.port);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Endpoint> {
        public Builder address(String var1);

        public Builder port(Integer var1);
    }
}

