/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public final class DescribeDefaultClusterParametersPaginator
implements SdkIterable<DescribeDefaultClusterParametersResponse> {
    private final RedshiftClient client;
    private final DescribeDefaultClusterParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDefaultClusterParametersPaginator(RedshiftClient client, DescribeDefaultClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDefaultClusterParametersResponseFetcher();
    }

    public Iterator<DescribeDefaultClusterParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Parameter> parameters() {
        Function<DescribeDefaultClusterParametersResponse, Iterator> getIterator = response -> response != null ? response.defaultClusterParameters().parameters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDefaultClusterParametersResponseFetcher
    implements NextPageFetcher<DescribeDefaultClusterParametersResponse> {
        private DescribeDefaultClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDefaultClusterParametersResponse previousPage) {
            return previousPage.defaultClusterParameters().marker() != null;
        }

        public DescribeDefaultClusterParametersResponse nextPage(DescribeDefaultClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDefaultClusterParametersPaginator.this.client.describeDefaultClusterParameters(DescribeDefaultClusterParametersPaginator.this.firstRequest);
            }
            return DescribeDefaultClusterParametersPaginator.this.client.describeDefaultClusterParameters((DescribeDefaultClusterParametersRequest)((Object)DescribeDefaultClusterParametersPaginator.this.firstRequest.toBuilder().marker(previousPage.defaultClusterParameters().marker()).build()));
        }
    }
}

