/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteClusterRequest> {
    private final String clusterIdentifier;
    private final Boolean skipFinalClusterSnapshot;
    private final String finalClusterSnapshotIdentifier;

    private DeleteClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.skipFinalClusterSnapshot = builder.skipFinalClusterSnapshot;
        this.finalClusterSnapshotIdentifier = builder.finalClusterSnapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Boolean skipFinalClusterSnapshot() {
        return this.skipFinalClusterSnapshot;
    }

    public String finalClusterSnapshotIdentifier() {
        return this.finalClusterSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalClusterSnapshotIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.skipFinalClusterSnapshot(), other.skipFinalClusterSnapshot()) && Objects.equals(this.finalClusterSnapshotIdentifier(), other.finalClusterSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.skipFinalClusterSnapshot() != null) {
            sb.append("SkipFinalClusterSnapshot: ").append(this.skipFinalClusterSnapshot()).append(",");
        }
        if (this.finalClusterSnapshotIdentifier() != null) {
            sb.append("FinalClusterSnapshotIdentifier: ").append(this.finalClusterSnapshotIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SkipFinalClusterSnapshot": {
                return Optional.of(clazz.cast(this.skipFinalClusterSnapshot()));
            }
            case "FinalClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.finalClusterSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Boolean skipFinalClusterSnapshot;
        private String finalClusterSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.skipFinalClusterSnapshot(model.skipFinalClusterSnapshot);
            this.finalClusterSnapshotIdentifier(model.finalClusterSnapshotIdentifier);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getSkipFinalClusterSnapshot() {
            return this.skipFinalClusterSnapshot;
        }

        @Override
        public final Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
            return this;
        }

        public final void setSkipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
        }

        public final String getFinalClusterSnapshotIdentifier() {
            return this.finalClusterSnapshotIdentifier;
        }

        @Override
        public final Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
            return this;
        }

        public final void setFinalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, DeleteClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder skipFinalClusterSnapshot(Boolean var1);

        public Builder finalClusterSnapshotIdentifier(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

