/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;

public class DisableLoggingRequestMarshaller
implements Marshaller<Request<DisableLoggingRequest>, DisableLoggingRequest> {
    public Request<DisableLoggingRequest> marshall(DisableLoggingRequest disableLoggingRequest) {
        if (disableLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableLoggingRequest, "RedshiftClient");
        request.addParameter("Action", "DisableLogging");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableLoggingRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)disableLoggingRequest.clusterIdentifier()));
        }
        return request;
    }
}

