/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;

public final class DescribeClusterVersionsPaginator
implements SdkIterable<DescribeClusterVersionsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterVersionsPaginator(RedshiftClient client, DescribeClusterVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public Iterator<DescribeClusterVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ClusterVersion> clusterVersions() {
        Function<DescribeClusterVersionsResponse, Iterator> getIterator = response -> response != null ? response.clusterVersions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterVersionsResponseFetcher
    implements NextPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterVersionsResponse nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsPaginator.this.client.describeClusterVersions(DescribeClusterVersionsPaginator.this.firstRequest);
            }
            return DescribeClusterVersionsPaginator.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

